/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.client.GuiCustomModLoadingErrorScreen;
import cpw.mods.fml.client.GuiDupesFound;
import cpw.mods.fml.client.GuiModsMissing;
import cpw.mods.fml.client.GuiSortingProblem;
import cpw.mods.fml.client.GuiWrongMinecraft;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private azd client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;
    private MissingModsException modsMissing;
    private ModSortingException modSorting;
    private boolean loading = true;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;
    private DuplicateModsFoundException dupesFound;
    private boolean serverShouldBeKilledQuietly;
    private List<bqr> resourcePackList;
    private bqm resourceManager;
    private Map<String, bqr> resourcePackMap;

    public void beginMinecraftLoading(azd minecraft, List resourcePackList, bqm resourceManager) {
        this.client = minecraft;
        this.resourcePackList = resourcePackList;
        this.resourceManager = resourceManager;
        this.resourcePackMap = Maps.newHashMap();
        if (minecraft.t()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        FMLCommonHandler.instance().beginLoading(this);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info"), "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (DuplicateModsFoundException dupes) {
            this.dupesFound = dupes;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (ModSortingException sorting) {
            this.modSorting = sorting;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        Map sharedModList = (Map)Launch.blackboard.get("modList");
        if (sharedModList == null) {
            sharedModList = Maps.newHashMap();
            Launch.blackboard.put("modList", sharedModList);
        }
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            Map<String, String> sharedModDescriptor = mc.getSharedModDescriptor();
            if (sharedModDescriptor == null) continue;
            String sharedModId = "fml:" + mc.getModId();
            sharedModList.put(sharedModId, sharedModDescriptor);
        }
    }

    @Override
    public void haltGame(String message, Throwable t) {
        this.client.c(new b(message, t));
        throw Throwables.propagate((Throwable)t);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null || this.customError != null || this.dupesFound != null || this.modSorting != null) {
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            return;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        RenderingRegistry.instance().loadEntityRenderers(bnf.a.q);
        this.loading = false;
    }

    public void extendModList() {
        Map modList = (Map)Launch.blackboard.get("modList");
        if (modList != null) {
            for (Map.Entry modEntry : modList.entrySet()) {
                String sharedModId = (String)modEntry.getKey();
                String system = sharedModId.split(":")[0];
                if ("fml".equals(system)) continue;
                Map mod = (Map)modEntry.getValue();
                String modSystem = (String)mod.get("modsystem");
                String modId = (String)mod.get("id");
                String modVersion = (String)mod.get("version");
                String modName = (String)mod.get("name");
                String modURL = (String)mod.get("url");
                String modAuthors = (String)mod.get("authors");
                String modDescription = (String)mod.get("description");
            }
        }
    }

    public void onInitializationComplete() {
        if (this.wrongMC != null) {
            this.showGuiScreen((Object)new GuiWrongMinecraft(this.wrongMC));
        } else if (this.modsMissing != null) {
            this.showGuiScreen((Object)new GuiModsMissing(this.modsMissing));
        } else if (this.dupesFound != null) {
            this.showGuiScreen((Object)new GuiDupesFound(this.dupesFound));
        } else if (this.modSorting != null) {
            this.showGuiScreen((Object)new GuiSortingProblem(this.modSorting));
        } else if (this.customError != null) {
            this.showGuiScreen((Object)new GuiCustomModLoadingErrorScreen(this.customError));
        }
    }

    public azd getClient() {
        return this.client;
    }

    public Logger getMinecraftLogger() {
        return null;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(xl player, bcd gui) {
        if (this.client.h == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        bcd gui = (bcd)clientGuiElement;
        this.client.a(gui);
    }

    public biz getWorldClient() {
        return this.client.f;
    }

    public bje getClientPlayerEntity() {
        return this.client.h;
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.G();
    }

    public void displayMissingMods(Object modMissingPacket) {
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    public boolean isGUIOpen(Class<? extends bcd> gui) {
        return this.client.n != null && this.client.n.getClass().equals(gui);
    }

    @Override
    public void addModAsResource(ModContainer container) {
        Class<?> resourcePackType = container.getCustomResourcePackClass();
        if (resourcePackType != null) {
            try {
                bqr pack = (bqr)resourcePackType.getConstructor(ModContainer.class).newInstance(container);
                this.resourcePackList.add(pack);
                this.resourcePackMap.put(container.getModId(), pack);
            }
            catch (NoSuchMethodException e) {
                FMLLog.log(Level.ERROR, "The container %s (type %s) returned an invalid class for it's resource pack.", container.getName(), container.getClass().getName());
                return;
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "An unexpected exception occurred constructing the custom resource pack for %s", container.getName());
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    public void updateResourcePackList() {
        this.client.b();
    }

    public bqr getResourcePackFor(String modId) {
        return this.resourcePackMap.get(modId);
    }

    @Override
    public String getCurrentLanguage() {
        return this.client.Q().c().a();
    }

    @Override
    public void serverStopped() {
        MinecraftServer server = this.getServer();
        if (server != null && !server.ah()) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(true), "field_71296_Q", "serverIsRunning");
        }
    }

    @Override
    public ef getClientToServerNetworkManager() {
        return this.client.u() != null ? this.client.u().b() : null;
    }

    public void handleClientWorldClosing(biz field_71441_e) {
        GameData.revertToFrozen();
    }
}

