/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.EntitySpawnHandler;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.network.internal.FMLRuntimeCodec;
import cpw.mods.fml.common.network.internal.HandshakeCompletionHandler;
import cpw.mods.fml.common.network.internal.NetworkModHolder;
import cpw.mods.fml.common.network.internal.OpenGuiHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.helpers.Integers;

public class FMLNetworkHandler {
    public static final int READ_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.readTimeout", "30"), (int)30);
    public static final int LOGIN_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.loginTimeout", "600"), (int)600);
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void fmlServerHandshake(ld scm, ef manager, mm player) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(manager, scm);
        dispatcher.serverToClientHandshake(player);
    }

    public static void fmlClientHandshake(ef field_147393_d) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(field_147393_d);
        dispatcher.clientToServerHandshake();
    }

    public static void openGui(xl entityPlayer, Object mod, int modGuiId, afn world, int x, int y, int z2) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (entityPlayer instanceof mm) {
            mm entityPlayerMP = (mm)entityPlayer;
            ye remoteGuiContainer = NetworkRegistry.INSTANCE.getRemoteGuiContainer(mc, entityPlayerMP, modGuiId, world, x, y, z2);
            if (remoteGuiContainer != null) {
                entityPlayerMP.getNextWindowId();
                entityPlayerMP.closeContainer();
                int windowId = entityPlayerMP.currentWindowId;
                FMLMessage.OpenGui openGui = new FMLMessage.OpenGui(windowId, mc.getModId(), modGuiId, x, y, z2);
                EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayerMP);
                embeddedChannel.writeOutbound(new Object[]{openGui});
                entityPlayerMP.openContainer = remoteGuiContainer;
                entityPlayerMP.openContainer.windowId = windowId;
                entityPlayerMP.openContainer.addCraftingToCrafters((yo)entityPlayerMP);
            }
        } else if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            Object guiContainer = NetworkRegistry.INSTANCE.getLocalGuiContainer(mc, entityPlayer, modGuiId, world, x, y, z2);
            FMLCommonHandler.instance().showGuiScreen(guiContainer);
        } else {
            FMLLog.fine("Invalid attempt to open a local GUI on a dedicated server. This is likely a bug. GUIID: %s,%d", mc.getModId(), modGuiId);
        }
    }

    public static void makeEntitySpawnAdjustment(qn entity, mm player, int serverX, int serverY, int serverZ) {
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        embeddedChannel.writeOutbound(new Object[]{new FMLMessage.EntityAdjustMessage(entity, serverX, serverY, serverZ)});
    }

    public static fk getEntitySpawningPacket(qn entity) {
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er == null) {
            return null;
        }
        if (er.usesVanillaSpawning()) {
            return null;
        }
        return channelPair.get((Object)Side.SERVER).generatePacketFrom(new FMLMessage.EntitySpawnMessage(er, entity, er.getContainer()));
    }

    public static String checkModList(FMLHandshakeMessage.ModList modListPacket, Side side) {
        Map<String, String> modList = modListPacket.modList();
        return FMLNetworkHandler.checkModList(modList, side);
    }

    public static String checkModList(Map<String, String> listData, Side side) {
        ArrayList rejects = Lists.newArrayList();
        for (Map.Entry<ModContainer, NetworkModHolder> networkMod : NetworkRegistry.INSTANCE.registry().entrySet()) {
            boolean result = networkMod.getValue().check(listData, side);
            if (result) continue;
            rejects.add(networkMod.getKey());
        }
        if (rejects.isEmpty()) {
            return null;
        }
        FMLLog.info("Rejecting connection %s: %s", new Object[]{side, rejects});
        return String.format("Mod rejections %s", rejects);
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        ChannelPipeline pipeline = channelPair.get((Object)Side.CLIENT).pipeline();
        String targetName = channelPair.get((Object)Side.CLIENT).findChannelHandlerNameForType(FMLRuntimeCodec.class);
        pipeline.addAfter(targetName, "GuiHandler", (ChannelHandler)new OpenGuiHandler());
        pipeline.addAfter(targetName, "EntitySpawnHandler", (ChannelHandler)new EntitySpawnHandler());
    }

    public static void registerChannel(FMLContainer container, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(container, "FML", new ChannelHandler[]{new FMLRuntimeCodec(), new HandshakeCompletionHandler()});
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        if (side == Side.CLIENT) {
            FMLNetworkHandler.addClientHandlers();
        }
    }

    public static List<FMLProxyPacket> forwardHandshake(FMLMessage.CompleteHandshake push, NetworkDispatcher target, Side side) {
        channelPair.get((Object)side).attr(NetworkDispatcher.FML_DISPATCHER).set((Object)target);
        channelPair.get((Object)side).writeOutbound(new Object[]{push});
        ArrayList<FMLProxyPacket> list = new ArrayList<FMLProxyPacket>();
        for (Object o : channelPair.get((Object)side).outboundMessages()) {
            list.add((FMLProxyPacket)((Object)o));
        }
        channelPair.get((Object)side).outboundMessages().clear();
        return list;
    }

    public static void enhanceStatusQuery(JsonObject jsonobject) {
        JsonObject fmlData = new JsonObject();
        fmlData.addProperty("type", "FML");
        JsonArray modList = new JsonArray();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            JsonObject modData = new JsonObject();
            modData.addProperty("modid", mc.getModId());
            modData.addProperty("version", mc.getVersion());
            modList.add((JsonElement)modData);
        }
        fmlData.add("modList", (JsonElement)modList);
        jsonobject.add("modinfo", (JsonElement)fmlData);
    }
}

