/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.base.Throwables;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.logging.log4j.Level;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    protected void channelRead0(ChannelHandlerContext ctx, FMLMessage.EntityMessage msg) throws Exception {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            this.spawnEntity((FMLMessage.EntitySpawnMessage)msg);
        } else if (msg.getClass().equals(FMLMessage.EntityAdjustMessage.class)) {
            this.adjustEntity((FMLMessage.EntityAdjustMessage)msg);
        }
    }

    private void adjustEntity(FMLMessage.EntityAdjustMessage msg) {
        qn ent = FMLClientHandler.instance().getWorldClient().getEntityByID(msg.entityId);
        if (ent != null) {
            ent.serverPosX = msg.serverX;
            ent.serverPosY = msg.serverY;
            ent.serverPosZ = msg.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", msg.entityId);
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, spawnMsg.modEntityTypeId);
        biz wc = FMLClientHandler.instance().getWorldClient();
        Class<? extends qn> cls = er.getEntityClass();
        try {
            qn entity;
            if (er.hasCustomSpawning()) {
                entity = er.doCustomSpawning(spawnMsg);
            } else {
                qn[] parts;
                entity = cls.getConstructor(afn.class).newInstance(wc);
                int offset = spawnMsg.entityId - entity.getEntityId();
                entity.setEntityId(spawnMsg.entityId);
                entity.setLocationAndAngles(spawnMsg.scaledX, spawnMsg.scaledY, spawnMsg.scaledZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof ri) {
                    ((ri)entity).rotationYawHead = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.getParts()) != null) {
                    for (int j = 0; j < parts.length; ++j) {
                        parts[j].setEntityId(parts[j].getEntityId() + offset);
                    }
                }
            }
            entity.serverPosX = spawnMsg.rawX;
            entity.serverPosY = spawnMsg.rawY;
            entity.serverPosZ = spawnMsg.rawZ;
            bje clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                bje thrower = clientPlayer.getEntityId() == spawnMsg.throwerId ? clientPlayer : wc.getEntityByID(spawnMsg.throwerId);
                ((IThrowableEntity)entity).setThrower((qn)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.getDataWatcher().updateWatchedObjectsFromList(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.setVelocity(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(spawnMsg.dataStream);
            }
            wc.addEntityToWorld(spawnMsg.entityId, entity);
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "EntitySpawnHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

