/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.Level;

public class ZipperUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File directory, File zipfile) throws IOException {
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        FileOutputStream out = new FileOutputStream(zipfile);
        Closeable res = null;
        try {
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                directory = (File)queue.pop();
                for (File kid : directory.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    Files.copy((File)kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
        finally {
            res.close();
        }
    }

    public static void backupWorld() throws IOException {
        String dirName = FMLCommonHandler.instance().getMinecraftServerInstance().getFolderName();
        ZipperUtil.backupWorld(dirName);
    }

    @Deprecated
    public static void backupWorld(String dirName, String saveName) throws IOException {
        ZipperUtil.backupWorld(dirName);
    }

    public static void backupWorld(String dirName) throws IOException {
        File dstFolder = FMLCommonHandler.instance().getSavesDirectory();
        File zip = new File(dstFolder, String.format("%s-%2$tY%2$tm%2$td-%2$tH%2$tM%2$tS.zip", dirName, System.currentTimeMillis()));
        try {
            ZipperUtil.zip(new File(dstFolder, dirName), zip);
        }
        catch (IOException e) {
            FMLLog.log(Level.WARN, e, "World backup failed.", new Object[0]);
            throw e;
        }
        FMLLog.info("World backup created at %s.", zip.getCanonicalPath());
    }
}

