/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dg getDataForWriting(axc handler, axe info) {
        dg fmlData = new dg();
        dp list = new dp();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            dg mod = new dg();
            mod.setString("ModId", mc.getModId());
            mod.setString("ModVersion", mc.getVersion());
            list.appendTag((du)mod);
        }
        fmlData.setTag("ModList", (du)list);
        dp dataList = new dp();
        FMLLog.fine("Gathering id map for writing to world save %s", info.getWorldName());
        Map<String, Integer> itemList = GameData.buildItemDataList();
        for (Map.Entry<String, Integer> item : itemList.entrySet()) {
            dg tag = new dg();
            tag.setString("K", item.getKey());
            tag.setInteger("V", item.getValue().intValue());
            dataList.appendTag((du)tag);
        }
        fmlData.setTag("ItemData", (du)dataList);
        fmlData.setIntArray("BlockedItemIds", GameData.getBlockedIds());
        dp blockAliasList = new dp();
        for (Map.Entry<String, String> entry : GameData.getBlockRegistry().getAliases().entrySet()) {
            dg tag = new dg();
            tag.setString("K", entry.getKey());
            tag.setString("V", entry.getValue());
            blockAliasList.appendTag((du)tag);
        }
        fmlData.setTag("BlockAliases", (du)blockAliasList);
        dp itemAliasList = new dp();
        for (Map.Entry<String, String> entry : GameData.getItemRegistry().getAliases().entrySet()) {
            dg tag = new dg();
            tag.setString("K", entry.getKey());
            tag.setString("V", entry.getValue());
            itemAliasList.appendTag((du)tag);
        }
        fmlData.setTag("ItemAliases", (du)itemAliasList);
        return fmlData;
    }

    @Override
    public void readData(axc handler, axe info, Map<String, du> propertyMap, dg tag) {
        LinkedHashMap dataList;
        if (tag.hasKey("ModList")) {
            dp modList = tag.getTagList("ModList", 10);
            for (int i = 0; i < modList.tagCount(); ++i) {
                dg mod = modList.getCompoundTagAt(i);
                String modId = mod.getString("ModId");
                String modVersion = mod.getString("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.hasKey("ModItemData")) {
            FMLLog.info("Attempting to convert old world data to new system. This may be trouble!", new Object[0]);
            dp modList = tag.getTagList("ModItemData", 10);
            dataList = Maps.newLinkedHashMap();
            for (int i = 0; i < modList.tagCount(); ++i) {
                String forcedName;
                dg itemTag = modList.getCompoundTagAt(i);
                String modId = itemTag.getString("ModId");
                String itemType = itemTag.getString("ItemType");
                int itemId = itemTag.getInteger("ItemId");
                int ordinal = itemTag.getInteger("ordinal");
                String forcedModId = itemTag.hasKey("ForcedModId") ? itemTag.getString("ForcedModId") : null;
                String string = forcedName = itemTag.hasKey("ForcedName") ? itemTag.getString("ForcedName") : null;
                if (forcedName == null) {
                    FMLLog.warning("Found unlabelled item in world save, this may cause problems. The item type %s:%d will not be present", itemType, ordinal);
                    continue;
                }
                String itemLabel = String.format("%c%s:%s", Character.valueOf('\u0002'), forcedModId != null ? forcedModId : modId, forcedName);
                dataList.put(itemLabel, itemId);
            }
            failedElements = GameData.injectWorldIDMap(dataList, true, true);
        } else if (tag.hasKey("ItemData")) {
            dp list = tag.getTagList("ItemData", 10);
            dataList = Maps.newLinkedHashMap();
            for (int i = 0; i < list.tagCount(); ++i) {
                dg dataTag = list.getCompoundTagAt(i);
                dataList.put(dataTag.getString("K"), dataTag.getInteger("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            if (!tag.hasKey("BlockedItemIds")) {
                GameData.fixBrokenIds(dataList, blockedIds);
            }
            for (int id : tag.getIntArray("BlockedItemIds")) {
                blockedIds.add(id);
            }
            HashMap<String, String> blockAliases = new HashMap<String, String>();
            list = tag.getTagList("BlockAliases", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                dg dataTag = list.getCompoundTagAt(i);
                blockAliases.put(dataTag.getString("K"), dataTag.getString("V"));
            }
            HashMap<String, String> itemAliases = new HashMap<String, String>();
            list = tag.getTagList("ItemAliases", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                dg dataTag = list.getCompoundTagAt(i);
                itemAliases.put(dataTag.getString("K"), dataTag.getString("V"));
            }
            failedElements = GameData.injectWorldIDMap(dataList, blockedIds, blockAliases, itemAliases, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "cpw.mods.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

