/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Strings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.GuiSlotModList;
import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class GuiModList
extends bcd {
    private bcd mainMenu;
    private GuiSlotModList modList;
    private int selected = -1;
    private ModContainer selectedMod;
    private int listWidth;
    private ArrayList<ModContainer> mods;
    private ban configModButton;
    private ban disableModButton;
    private bqo cachedLogo;
    private Dimension cachedLogoDimensions;

    public GuiModList(bcd mainMenu) {
        this.mainMenu = mainMenu;
        this.mods = new ArrayList();
        FMLClientHandler.instance().addSpecialModEntries(this.mods);
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getMetadata() != null && mod.getMetadata().parentMod == null && !Strings.isNullOrEmpty((String)mod.getMetadata().parent)) {
                String parentMod = mod.getMetadata().parent;
                ModContainer parentContainer = Loader.instance().getIndexedModList().get(parentMod);
                if (parentContainer != null) {
                    mod.getMetadata().parentMod = parentContainer;
                    parentContainer.getMetadata().childMods.add(mod);
                    continue;
                }
            } else if (mod.getMetadata() != null && mod.getMetadata().parentMod != null) continue;
            this.mods.add(mod);
        }
    }

    public void initGui() {
        for (ModContainer mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().getStringWidth(mod.getName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().getStringWidth(mod.getVersion()) + 10);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.buttonList.add(new ban(6, this.width / 2 - 75, this.height - 38, bra.format((String)"gui.done", (Object[])new Object[0])));
        this.configModButton = new ban(20, 10, this.height - 60, this.listWidth, 20, "Config");
        this.disableModButton = new ban(21, 10, this.height - 38, this.listWidth, 20, "Disable");
        this.buttonList.add(this.configModButton);
        this.buttonList.add(this.disableModButton);
        this.modList = new GuiSlotModList(this, this.mods, this.listWidth);
        this.modList.registerScrollButtons(this.buttonList, 7, 8);
    }

    protected void actionPerformed(ban button) {
        if (button.enabled) {
            switch (button.id) {
                case 6: {
                    this.mc.displayGuiScreen(this.mainMenu);
                    return;
                }
                case 20: {
                    try {
                        IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                        bcd newScreen = guiFactory.mainConfigGuiClass().getConstructor(bcd.class).newInstance(new Object[]{this});
                        this.mc.displayGuiScreen(newScreen);
                    }
                    catch (Exception e) {
                        FMLLog.log(Level.ERROR, e, "There was a critical issue trying to build the config GUI for %s", this.selectedMod.getModId());
                    }
                    return;
                }
            }
        }
        super.actionPerformed(button);
    }

    public int drawLine(String line, int offset, int shifty) {
        this.fontRendererObj.drawString(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    public void drawScreen(int p_571_1_, int p_571_2_, float p_571_3_) {
        this.modList.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        this.drawCenteredString(this.fontRendererObj, "Mod List", this.width / 2, 16, 0xFFFFFF);
        int offset = this.listWidth + 20;
        if (this.selectedMod != null) {
            GL11.glEnable((int)3042);
            if (!this.selectedMod.getMetadata().autogenerated) {
                ModContainer.Disableable disableable;
                this.configModButton.visible = true;
                this.disableModButton.visible = true;
                this.disableModButton.packedFGColour = 0xFF3377;
                this.configModButton.enabled = false;
                int shifty = 35;
                String logoFile = this.selectedMod.getMetadata().logoFile;
                if (!logoFile.isEmpty()) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    bpx tm = this.mc.getTextureManager();
                    bqr pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
                    try {
                        if (this.cachedLogo == null) {
                            BufferedImage logo = null;
                            if (pack != null) {
                                logo = pack.getPackImage();
                            } else {
                                InputStream logoResource = ((Object)((Object)this)).getClass().getResourceAsStream(logoFile);
                                if (logoResource != null) {
                                    logo = ImageIO.read(logoResource);
                                }
                            }
                            if (logo != null) {
                                this.cachedLogo = tm.getDynamicTextureLocation("modlogo", new bpi(logo));
                                this.cachedLogoDimensions = new Dimension(logo.getWidth(), logo.getHeight());
                            }
                        }
                        if (this.cachedLogo != null) {
                            this.mc.renderEngine.bindTexture(this.cachedLogo);
                            double scaleX = (double)this.cachedLogoDimensions.width / 200.0;
                            double scaleY = (double)this.cachedLogoDimensions.height / 65.0;
                            double scale = 1.0;
                            if (scaleX > 1.0 || scaleY > 1.0) {
                                scale = 1.0 / Math.max(scaleX, scaleY);
                            }
                            this.cachedLogoDimensions.width = (int)((double)this.cachedLogoDimensions.width * scale);
                            this.cachedLogoDimensions.height = (int)((double)this.cachedLogoDimensions.height * scale);
                            int top = 32;
                            blz tess = blz.instance;
                            tess.startDrawingQuads();
                            tess.addVertexWithUV((double)offset, (double)(top + this.cachedLogoDimensions.height), (double)this.zLevel, 0.0, 1.0);
                            tess.addVertexWithUV((double)(offset + this.cachedLogoDimensions.width), (double)(top + this.cachedLogoDimensions.height), (double)this.zLevel, 1.0, 1.0);
                            tess.addVertexWithUV((double)(offset + this.cachedLogoDimensions.width), (double)top, (double)this.zLevel, 1.0, 0.0);
                            tess.addVertexWithUV((double)offset, (double)top, (double)this.zLevel, 0.0, 0.0);
                            tess.draw();
                            shifty += 65;
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.fontRendererObj.drawStringWithShadow(this.selectedMod.getMetadata().name, offset, shifty, 0xFFFFFF);
                shifty += 12;
                shifty = this.drawLine(String.format("Version: %s (%s)", this.selectedMod.getDisplayVersion(), this.selectedMod.getVersion()), offset, shifty);
                shifty = this.drawLine(String.format("Mod ID: '%s' Mod State: %s", new Object[]{this.selectedMod.getModId(), Loader.instance().getModState(this.selectedMod)}), offset, shifty);
                if (!this.selectedMod.getMetadata().credits.isEmpty()) {
                    shifty = this.drawLine(String.format("Credits: %s", this.selectedMod.getMetadata().credits), offset, shifty);
                }
                shifty = this.drawLine(String.format("Authors: %s", this.selectedMod.getMetadata().getAuthorList()), offset, shifty);
                shifty = this.drawLine(String.format("URL: %s", this.selectedMod.getMetadata().url), offset, shifty);
                shifty = this.drawLine(this.selectedMod.getMetadata().childMods.isEmpty() ? "No child mods for this mod" : String.format("Child mods: %s", this.selectedMod.getMetadata().getChildModList()), offset, shifty);
                int rightSide = this.width - offset - 20;
                if (rightSide > 20) {
                    this.getFontRenderer().drawSplitString(this.selectedMod.getMetadata().description, offset, shifty + 10, rightSide, 0xDDDDDD);
                }
                if ((disableable = this.selectedMod.canBeDisabled()) == ModContainer.Disableable.RESTART) {
                    this.disableModButton.enabled = true;
                    this.disableModButton.visible = true;
                    this.disableModButton.packedFGColour = 0xFF3377;
                } else if (disableable == ModContainer.Disableable.YES) {
                    this.disableModButton.enabled = true;
                    this.disableModButton.visible = true;
                    this.disableModButton.packedFGColour = 0;
                } else {
                    this.disableModButton.packedFGColour = 0;
                    this.disableModButton.visible = true;
                    this.disableModButton.enabled = false;
                }
                IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                if (guiFactory == null || guiFactory.mainConfigGuiClass() == null) {
                    this.configModButton.visible = true;
                    this.configModButton.enabled = false;
                } else {
                    this.configModButton.visible = true;
                    this.configModButton.enabled = true;
                }
            } else {
                offset = (this.listWidth + this.width) / 2;
                this.drawCenteredString(this.fontRendererObj, this.selectedMod.getName(), offset, 35, 0xFFFFFF);
                this.drawCenteredString(this.fontRendererObj, String.format("Version: %s", this.selectedMod.getVersion()), offset, 45, 0xFFFFFF);
                this.drawCenteredString(this.fontRendererObj, String.format("Mod State: %s", new Object[]{Loader.instance().getModState(this.selectedMod)}), offset, 55, 0xFFFFFF);
                this.drawCenteredString(this.fontRendererObj, "No mod information found", offset, 65, 0xDDDDDD);
                this.drawCenteredString(this.fontRendererObj, "Ask your mod author to provide a mod mcmod.info file", offset, 75, 0xDDDDDD);
                this.configModButton.visible = false;
                this.disableModButton.visible = false;
            }
            GL11.glDisable((int)3042);
        } else {
            this.configModButton.visible = false;
            this.disableModButton.visible = false;
        }
        super.drawScreen(p_571_1_, p_571_2_, p_571_3_);
    }

    azd getMinecraftInstance() {
        return this.mc;
    }

    bag getFontRenderer() {
        return this.fontRendererObj;
    }

    public void selectModIndex(int var1) {
        this.selected = var1;
        this.selectedMod = var1 >= 0 && var1 <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.cachedLogo = null;
    }

    public boolean modIndexSelected(int var1) {
        return var1 == this.selected;
    }
}

