/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;

    private FMLServerHandler() {
        FMLCommonHandler.instance().beginLoading(this);
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    @Override
    public void addModAsResource(ModContainer container) {
        LanguageRegistry.instance().loadLanguagesFor(container, Side.SERVER);
    }

    @Override
    public void updateResourcePackList() {
    }

    @Override
    public String getCurrentLanguage() {
        return "en_US";
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public ef getClientToServerNetworkManager() {
        throw new RuntimeException("Missing");
    }

    @Override
    public es getClientPlayHandler() {
        return null;
    }

    @Override
    public void waitForPlayClient() {
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, ef manager, Set<String> channelSet, String channel, Side side) {
        bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<mx>(manager, channelSet, channel, side, mx.class));
    }
}

