/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import java.io.File;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;

public class ModContainerFactory {
    private static Pattern modClass = Pattern.compile(".*(\\.|)(mod\\_[^\\s$]+)$");
    private static ModContainerFactory INSTANCE = new ModContainerFactory();

    public static ModContainerFactory instance() {
        return INSTANCE;
    }

    public ModContainer build(ASMModParser modParser, File modSource, ModCandidate container) {
        String className = modParser.getASMType().getClassName();
        if (modParser.isBaseMod(container.getRememberedBaseMods()) && modClass.matcher(className).find()) {
            FMLLog.severe("Found a BaseMod type mod %s", className);
            FMLLog.severe("This will not be loaded and will be ignored. ModLoader mechanisms are no longer available.", new Object[0]);
        } else if (modClass.matcher(className).find()) {
            FMLLog.fine("Identified a class %s following modloader naming convention but not directly a BaseMod or currently seen subclass", className);
            container.rememberModCandidateType(modParser);
        } else if (modParser.isBaseMod(container.getRememberedBaseMods())) {
            FMLLog.fine("Found a basemod %s of non-standard naming format", className);
            container.rememberBaseModType(className);
        }
        for (ModAnnotation ann : modParser.getAnnotations()) {
            if (!ann.getASMType().equals((Object)Type.getType(Mod.class))) continue;
            FMLLog.fine("Identified an FMLMod type mod %s", className);
            return new FMLModContainer(className, container, ann.getValues());
        }
        return null;
    }
}

