/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.ListenerList;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Event {
    private boolean isCanceled = false;
    private final boolean isCancelable;
    private Result result = Result.DEFAULT;
    private final boolean hasResult;
    private static ListenerList listeners = new ListenerList();
    private static final Map<Class<?>, Map<Class<?>, Boolean>> annotationMap = new ConcurrentHashMap();

    public Event() {
        this.setup();
        this.isCancelable = this.hasAnnotation(Cancelable.class);
        this.hasResult = this.hasAnnotation(HasResult.class);
    }

    private boolean hasAnnotation(Class<? extends Annotation> annotation) {
        Boolean cached;
        Class<?> me = this.getClass();
        Map<Class<?>, Boolean> list = annotationMap.get(me);
        if (list == null) {
            list = new ConcurrentHashMap();
            annotationMap.put(me, list);
        }
        if ((cached = list.get(annotation)) != null) {
            return cached;
        }
        for (Class<?> cls = me; cls != Event.class; cls = cls.getSuperclass()) {
            if (!cls.isAnnotationPresent(annotation)) continue;
            list.put(annotation, true);
            return true;
        }
        list.put(annotation, false);
        return false;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new IllegalArgumentException("Attempted to cancel a uncancelable event");
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    protected void setup() {
    }

    public ListenerList getListenerList() {
        return listeners;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

