/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;

@Deprecated
public class SplashProgress {
    private static Drawable d;
    private static volatile boolean pause;
    private static volatile boolean done;
    private static Thread thread;
    private static int angle;
    private static final Lock lock;
    private static SplashFontRenderer fontRenderer;
    private static final bra mcPack;
    private static final bra fmlPack;
    private static int fontTexture;
    private static bqx fontLocation;
    private static int logoTexture;
    private static bqx logoLocation;
    private static int forgeTexture;
    private static bqx forgeLocation;
    private static bqx configLocation;
    private static final Properties config;
    private static final boolean enabled;
    private static final int backgroundColor;
    private static final int fontColor;
    private static final int barBorderColor;
    private static final int barColor;
    private static final int barBackgroundColor;

    public static void start() {
        if (!enabled) {
            return;
        }
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            @Override
            public String call() throws Exception {
                return "' Vendor: '" + GL11.glGetString((int)7936) + "' Version: '" + GL11.glGetString((int)7938) + "' Renderer: '" + GL11.glGetString((int)7937) + "'";
            }

            @Override
            public String getLabel() {
                return "GL info";
            }
        });
        b report = b.a((Throwable)new Throwable(), (String)"Loading screen debug info");
        System.out.println(report.e());
        fontTexture = GL11.glGenTextures();
        SplashProgress.loadTexture(mcPack, fontTexture, fontLocation);
        logoTexture = GL11.glGenTextures();
        SplashProgress.loadTexture(mcPack, logoTexture, logoLocation);
        forgeTexture = GL11.glGenTextures();
        SplashProgress.loadTexture(fmlPack, forgeTexture, forgeLocation);
        try {
            d = new SharedDrawable(Display.getDrawable());
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Thread mainThread = Thread.currentThread();
        thread = new Thread(new Runnable(){
            private final int barWidth = 400;
            private final int barHeight = 20;
            private final int textHeight2 = 20;
            private final int barOffset = 55;

            @Override
            public void run() {
                this.setGL();
                while (!done) {
                    ProgressManager.ProgressBar first = null;
                    ProgressManager.ProgressBar penult = null;
                    ProgressManager.ProgressBar last = null;
                    Iterator<ProgressManager.ProgressBar> i = ProgressManager.barIterator();
                    while (i.hasNext()) {
                        if (first == null) {
                            first = i.next();
                            continue;
                        }
                        penult = last;
                        last = i.next();
                    }
                    GL11.glClear((int)16384);
                    int w = Display.getWidth();
                    int h = Display.getHeight();
                    GL11.glViewport((int)0, (int)0, (int)w, (int)h);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)(320 - w / 2), (double)(320 + w / 2), (double)(240 + h / 2), (double)(240 - h / 2), (double)-1.0, (double)1.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    this.setColor(backgroundColor);
                    GL11.glEnable((int)3553);
                    GL11.glBindTexture((int)3553, (int)logoTexture);
                    GL11.glBegin((int)7);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)64.0f, (float)-16.0f);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)64.0f, (float)496.0f);
                    GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                    GL11.glVertex2f((float)576.0f, (float)496.0f);
                    GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                    GL11.glVertex2f((float)576.0f, (float)-16.0f);
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    if (first != null) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)120.0f, (float)310.0f, (float)0.0f);
                        this.drawBar(first);
                        if (penult != null) {
                            GL11.glTranslatef((float)0.0f, (float)55.0f, (float)0.0f);
                            this.drawBar(penult);
                        }
                        if (last != null) {
                            GL11.glTranslatef((float)0.0f, (float)55.0f, (float)0.0f);
                            this.drawBar(last);
                        }
                        GL11.glPopMatrix();
                    }
                    angle += 1;
                    this.setColor(backgroundColor);
                    GL11.glTranslatef((float)680.0f, (float)420.0f, (float)0.0f);
                    GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glEnable((int)3553);
                    GL11.glBindTexture((int)3553, (int)forgeTexture);
                    GL11.glBegin((int)7);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)-50.0f, (float)-50.0f);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)-50.0f, (float)50.0f);
                    GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                    GL11.glVertex2f((float)50.0f, (float)50.0f);
                    GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                    GL11.glVertex2f((float)50.0f, (float)-50.0f);
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    Display.update();
                    if (pause) {
                        this.clearGL();
                        this.setGL();
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                this.clearGL();
            }

            private void setColor(int color) {
                GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            }

            private void drawBox(int w, int h) {
                GL11.glBegin((int)7);
                GL11.glVertex2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)0.0f, (float)h);
                GL11.glVertex2f((float)w, (float)h);
                GL11.glVertex2f((float)w, (float)0.0f);
                GL11.glEnd();
            }

            private void drawBar(ProgressManager.ProgressBar b2) {
                GL11.glPushMatrix();
                this.setColor(fontColor);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                fontRenderer.b(b2.getTitle() + " - " + b2.getMessage(), 0, 0, 0);
                GL11.glDisable((int)3553);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                this.setColor(barBorderColor);
                this.drawBox(400, 20);
                this.setColor(barBackgroundColor);
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                this.drawBox(398, 18);
                this.setColor(barColor);
                this.drawBox(398 * b2.getStep() / b2.getSteps(), 18);
                String progress = "" + b2.getStep() + "/" + b2.getSteps();
                GL11.glTranslatef((float)((398.0f - (float)fontRenderer.a(progress)) / 2.0f), (float)2.0f, (float)0.0f);
                this.setColor(fontColor);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                fontRenderer.b(progress, 0, 0, 0);
                GL11.glPopMatrix();
            }

            private void setGL() {
                lock.lock();
                try {
                    Display.getDrawable().makeCurrent();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                GL11.glClearColor((float)((float)(backgroundColor >> 16 & 0xFF) / 255.0f), (float)((float)(backgroundColor >> 8 & 0xFF) / 255.0f), (float)((float)(backgroundColor & 0xFF) / 255.0f), (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3553);
                if (fontRenderer == null) {
                    fontRenderer = new SplashFontRenderer();
                }
                GL11.glDisable((int)3553);
            }

            private void clearGL() {
                bao mc = bao.B();
                mc.d = Display.getWidth();
                mc.e = Display.getHeight();
                mc.a(mc.d, mc.e);
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)2929);
                GL11.glDepthFunc((int)515);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                try {
                    Display.getDrawable().releaseContext();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    lock.unlock();
                }
            }
        });
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                FMLLog.log(Level.ERROR, e, "Splash thread Exception", new Object[0]);
                bao.B().a(b.a((Throwable)e, (String)"Splash thread"));
            }
        });
        thread.start();
    }

    @Deprecated
    public static void pause() {
        if (!enabled) {
            return;
        }
        pause = true;
        lock.lock();
        try {
            d.releaseContext();
            Display.getDrawable().makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void resume() {
        if (!enabled) {
            return;
        }
        pause = false;
        try {
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        lock.unlock();
    }

    public static void finish() {
        if (!enabled) {
            return;
        }
        try {
            done = true;
            thread.join();
            d.releaseContext();
            Display.getDrawable().makeCurrent();
            GL11.glDeleteTextures((int)fontTexture);
            GL11.glDeleteTextures((int)logoTexture);
            GL11.glDeleteTextures((int)forgeTexture);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static bra createFmlResourcePack() {
        if (FMLSanityChecker.fmlLocation.isDirectory()) {
            return new bqs(FMLSanityChecker.fmlLocation);
        }
        return new bqr(FMLSanityChecker.fmlLocation);
    }

    private static Properties loadConfig() {
        InputStream s = null;
        try {
            s = fmlPack.a(configLocation);
            Properties config = new Properties();
            config.load(s);
            Properties properties = config;
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    private static int getInt(String name) {
        return Integer.decode(config.getProperty(name));
    }

    private static void loadTexture(bra pack, int name, bqx location) {
        InputStream s = null;
        try {
            s = pack.a(location);
            bqi.a((int)name, (BufferedImage)ImageIO.read(pack.a(location)), (boolean)false, (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    public static void drawVanillaScreen() throws LWJGLException {
        if (!enabled) {
            bao.B().aj();
        }
    }

    public static void clearVanillaResources(bqf renderEngine, bqx mojangLogo) {
        if (!enabled) {
            renderEngine.c(mojangLogo);
        }
    }

    static {
        pause = false;
        done = false;
        angle = 0;
        lock = new ReentrantLock(true);
        mcPack = bao.B().aq;
        fmlPack = SplashProgress.createFmlResourcePack();
        fontLocation = new bqx("textures/font/ascii.png");
        logoLocation = new bqx("textures/gui/title/mojang.png");
        forgeLocation = new bqx("fml", "textures/gui/forge.png");
        configLocation = new bqx("fml", "splash.properties");
        config = SplashProgress.loadConfig();
        enabled = Boolean.parseBoolean(config.getProperty("enabled"));
        backgroundColor = SplashProgress.getInt("background");
        fontColor = SplashProgress.getInt("font");
        barBorderColor = SplashProgress.getInt("barBorder");
        barColor = SplashProgress.getInt("bar");
        barBackgroundColor = SplashProgress.getInt("barBackground");
    }

    private static class SplashFontRenderer
    extends bbu {
        public SplashFontRenderer() {
            super(bao.B().u, fontLocation, null, false);
            super.a(null);
        }

        protected void bindTexture(bqx location) {
            if (location != this.g) {
                throw new IllegalArgumentException();
            }
            GL11.glBindTexture((int)3553, (int)fontTexture);
        }

        protected InputStream getResourceInputStream(bqx location) throws IOException {
            return bao.B().aq.a(location);
        }
    }
}

