/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.client.ExtendedServerListData;
import cpw.mods.fml.client.GuiAccessDenied;
import cpw.mods.fml.client.GuiConfirmation;
import cpw.mods.fml.client.GuiCustomModLoadingErrorScreen;
import cpw.mods.fml.client.GuiDupesFound;
import cpw.mods.fml.client.GuiIngameModOptions;
import cpw.mods.fml.client.GuiModsMissing;
import cpw.mods.fml.client.GuiNotification;
import cpw.mods.fml.client.GuiOldSaveLoadConfirm;
import cpw.mods.fml.client.GuiSortingProblem;
import cpw.mods.fml.client.GuiWrongMinecraft;
import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLContainerHolder;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private bao client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;
    private MissingModsException modsMissing;
    private ModSortingException modSorting;
    private boolean loading = true;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;
    private DuplicateModsFoundException dupesFound;
    private boolean serverShouldBeKilledQuietly;
    private List<bra> resourcePackList;
    private bqv resourceManager;
    private Map<String, bra> resourcePackMap;
    private BiMap<ModContainer, IModGuiFactory> guiFactories;
    private Map<kb, JsonObject> extraServerListData;
    private Map<bjn, ExtendedServerListData> serverDataTag;
    private WeakReference<bjb> currentPlayClient;
    private static final bqx iconSheet = new bqx("fml:textures/gui/icons.png");
    private static final CountDownLatch startupConnectionData = new CountDownLatch(1);
    private CountDownLatch playClientBlock;
    private SetMultimap<String, bqx> missingTextures = HashMultimap.create();
    private Set<String> badTextureDomains = Sets.newHashSet();
    private Table<String, String, Set<bqx>> brokenTextures = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginMinecraftLoading(bao minecraft, List resourcePackList, bqv resourceManager) {
        this.client = minecraft;
        this.resourcePackList = resourcePackList;
        this.resourceManager = resourceManager;
        this.resourcePackMap = Maps.newHashMap();
        if (minecraft.u()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        FMLCommonHandler.instance().beginLoading(this);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info"), "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (DuplicateModsFoundException dupes) {
            this.dupesFound = dupes;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (ModSortingException sorting) {
            this.modSorting = sorting;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        finally {
            this.client.c();
        }
        try {
            Loader.instance().preinitializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        Map sharedModList = (Map)Launch.blackboard.get("modList");
        if (sharedModList == null) {
            sharedModList = Maps.newHashMap();
            Launch.blackboard.put("modList", sharedModList);
        }
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            Map<String, String> sharedModDescriptor = mc.getSharedModDescriptor();
            if (sharedModDescriptor == null) continue;
            String sharedModId = "fml:" + mc.getModId();
            sharedModList.put(sharedModId, sharedModDescriptor);
        }
    }

    @Override
    public void haltGame(String message, Throwable t) {
        this.client.c(new b(message, t));
        throw Throwables.propagate((Throwable)t);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null || this.customError != null || this.dupesFound != null || this.modSorting != null) {
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            return;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        this.client.c();
        RenderingRegistry.instance().loadEntityRenderers(bnn.a.q);
        this.guiFactories = HashBiMap.create();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            String className = mc.getGuiClassName();
            if (Strings.isNullOrEmpty((String)className)) continue;
            try {
                Class<?> clazz = Class.forName(className, true, Loader.instance().getModClassLoader());
                Class<IModGuiFactory> guiClassFactory = clazz.asSubclass(IModGuiFactory.class);
                IModGuiFactory guiFactory = guiClassFactory.newInstance();
                guiFactory.initialize(this.client);
                this.guiFactories.put((Object)mc, (Object)guiFactory);
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "A critical error occurred instantiating the gui factory for mod %s", mc.getModId());
            }
        }
        this.loading = false;
        this.client.u.a();
    }

    public void extendModList() {
        Map modList = (Map)Launch.blackboard.get("modList");
        if (modList != null) {
            for (Map.Entry modEntry : modList.entrySet()) {
                String sharedModId = (String)modEntry.getKey();
                String system = sharedModId.split(":")[0];
                if ("fml".equals(system)) continue;
                Map mod = (Map)modEntry.getValue();
                String modSystem = (String)mod.get("modsystem");
                String modId = (String)mod.get("id");
                String modVersion = (String)mod.get("version");
                String modName = (String)mod.get("name");
                String modURL = (String)mod.get("url");
                String modAuthors = (String)mod.get("authors");
                String modDescription = (String)mod.get("description");
            }
        }
    }

    public void onInitializationComplete() {
        if (this.wrongMC != null) {
            this.showGuiScreen((Object)new GuiWrongMinecraft(this.wrongMC));
        } else if (this.modsMissing != null) {
            this.showGuiScreen((Object)new GuiModsMissing(this.modsMissing));
        } else if (this.dupesFound != null) {
            this.showGuiScreen((Object)new GuiDupesFound(this.dupesFound));
        } else if (this.modSorting != null) {
            this.showGuiScreen((Object)new GuiSortingProblem(this.modSorting));
        } else if (this.customError != null) {
            this.showGuiScreen((Object)new GuiCustomModLoadingErrorScreen(this.customError));
        }
        this.logMissingTextureErrors();
    }

    public bao getClient() {
        return this.client;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(yz player, bdw gui) {
        if (this.client.h == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        bdw gui = (bdw)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            this.client.a((bdw)new GuiNotification(query));
        } else {
            this.client.a((bdw)new GuiConfirmation(query));
        }
        if (query.isSynchronous()) {
            while (this.client.n instanceof GuiNotification) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.client.o.c("");
                Thread.sleep(50L);
            }
            this.client.o.c("");
        }
    }

    public boolean handleLoadingScreen(bca scaledResolution) {
        if (this.client.n instanceof GuiNotification) {
            int width = scaledResolution.a();
            int height = scaledResolution.b();
            int mouseX = Mouse.getX() * width / this.client.d;
            int mouseZ = height - Mouse.getY() * height / this.client.e - 1;
            this.client.n.a(mouseX, mouseZ, 0.0f);
            this.client.n.p();
            return true;
        }
        return false;
    }

    public bjf getWorldClient() {
        return this.client.f;
    }

    public bjk getClientPlayerEntity() {
        return this.client.h;
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public File getSavesDirectory() {
        return ((ayr)this.client.d()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.H();
    }

    public void displayMissingMods(Object modMissingPacket) {
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    public boolean isGUIOpen(Class<? extends bdw> gui) {
        return this.client.n != null && this.client.n.getClass().equals(gui);
    }

    @Override
    public void addModAsResource(ModContainer container) {
        LanguageRegistry.instance().loadLanguagesFor(container, Side.CLIENT);
        Class<?> resourcePackType = container.getCustomResourcePackClass();
        if (resourcePackType != null) {
            try {
                bra pack = (bra)resourcePackType.getConstructor(ModContainer.class).newInstance(container);
                this.resourcePackList.add(pack);
                this.resourcePackMap.put(container.getModId(), pack);
            }
            catch (NoSuchMethodException e) {
                FMLLog.log(Level.ERROR, "The container %s (type %s) returned an invalid class for it's resource pack.", container.getName(), container.getClass().getName());
                return;
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "An unexpected exception occurred constructing the custom resource pack for %s", container.getName());
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public bra getResourcePackFor(String modId) {
        return this.resourcePackMap.get(modId);
    }

    @Override
    public String getCurrentLanguage() {
        return this.client.S().c().a();
    }

    @Override
    public void serverStopped() {
        MinecraftServer server = this.getServer();
        if (server != null && !server.aj()) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(true), "field_71296_Q", "serverIsRunning");
        }
    }

    @Override
    public fb getClientPlayHandler() {
        return this.currentPlayClient == null ? null : (bjb)this.currentPlayClient.get();
    }

    @Override
    public ej getClientToServerNetworkManager() {
        return this.client.v() != null ? this.client.v().b() : null;
    }

    public void handleClientWorldClosing(bjf world) {
        ej client = this.getClientToServerNetworkManager();
        if (client != null && !client.c()) {
            GameData.revertToFrozen();
        }
    }

    public void startIntegratedServer(String id, String name, ahj settings) {
        this.playClientBlock = new CountDownLatch(1);
    }

    public File getSavesDir() {
        return new File(this.client.w, "saves");
    }

    public void tryLoadExistingWorld(bdx selectWorldGUI, String dirName, String saveName) {
        dh leveldat;
        File dir = new File(this.getSavesDir(), dirName);
        try {
            leveldat = du.a((InputStream)new FileInputStream(new File(dir, "level.dat")));
        }
        catch (Exception e) {
            try {
                leveldat = du.a((InputStream)new FileInputStream(new File(dir, "level.dat_old")));
            }
            catch (Exception e1) {
                FMLLog.warning("There appears to be a problem loading the save %s, both level files are unreadable.", dirName);
                return;
            }
        }
        dh fmlData = leveldat.m("FML");
        if (fmlData.c("ModItemData")) {
            this.showGuiScreen((Object)new GuiOldSaveLoadConfirm(dirName, saveName, (bdw)selectWorldGUI));
        } else {
            try {
                this.client.a(dirName, saveName, (ahj)null);
            }
            catch (StartupQuery.AbortedException e) {
                // empty catch block
            }
        }
    }

    public void showInGameModOptions(bdp guiIngameMenu) {
        this.showGuiScreen((Object)new GuiIngameModOptions((bdw)guiIngameMenu));
    }

    public IModGuiFactory getGuiFactoryFor(ModContainer selectedMod) {
        return (IModGuiFactory)this.guiFactories.get((Object)selectedMod);
    }

    public void setupServerList() {
        this.extraServerListData = Collections.synchronizedMap(Maps.newHashMap());
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    public void captureAdditionalData(kb serverstatusresponse, JsonObject jsonobject) {
        if (jsonobject.has("modinfo")) {
            JsonObject fmlData = jsonobject.get("modinfo").getAsJsonObject();
            this.extraServerListData.put(serverstatusresponse, fmlData);
        }
    }

    public void bindServerListData(bjn data, kb originalResponse) {
        if (this.extraServerListData.containsKey(originalResponse)) {
            JsonObject jsonData = this.extraServerListData.get(originalResponse);
            String type = jsonData.get("type").getAsString();
            JsonArray modDataArray = jsonData.get("modList").getAsJsonArray();
            boolean moddedClientAllowed = jsonData.has("clientModsAllowed") ? jsonData.get("clientModsAllowed").getAsBoolean() : true;
            ImmutableMap.Builder modListBldr = ImmutableMap.builder();
            for (JsonElement obj : modDataArray) {
                JsonObject modObj = obj.getAsJsonObject();
                modListBldr.put((Object)modObj.get("modid").getAsString(), (Object)modObj.get("version").getAsString());
            }
            ImmutableMap modListMap = modListBldr.build();
            this.serverDataTag.put(data, new ExtendedServerListData(type, FMLNetworkHandler.checkModList((Map<String, String>)modListMap, Side.SERVER) == null, (Map<String, String>)modListMap, !moddedClientAllowed));
        } else {
            String serverDescription = data.d;
            boolean moddedClientAllowed = true;
            if (!Strings.isNullOrEmpty((String)serverDescription)) {
                moddedClientAllowed = !serverDescription.endsWith(":NOFML\u00a7r");
            }
            this.serverDataTag.put(data, new ExtendedServerListData("VANILLA", false, (Map<String, String>)ImmutableMap.of(), !moddedClientAllowed));
        }
        startupConnectionData.countDown();
    }

    public String enhanceServerListEntry(bgc serverListEntry, bjn serverEntry, int x, int width, int y, int relativeMouseX, int relativeMouseY) {
        String tooltip;
        int idx;
        ExtendedServerListData extendedData;
        boolean blocked = false;
        if (this.serverDataTag.containsKey(serverEntry)) {
            extendedData = this.serverDataTag.get(serverEntry);
            if ("FML".equals(extendedData.type) && extendedData.isCompatible) {
                idx = 0;
                tooltip = String.format("Compatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("FML".equals(extendedData.type) && !extendedData.isCompatible) {
                idx = 16;
                tooltip = String.format("Incompatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("BUKKIT".equals(extendedData.type)) {
                idx = 32;
                tooltip = String.format("Bukkit modded server", new Object[0]);
            } else if ("VANILLA".equals(extendedData.type)) {
                idx = 48;
                tooltip = String.format("Vanilla server", new Object[0]);
            } else {
                idx = 64;
                tooltip = String.format("Unknown server data", new Object[0]);
            }
        } else {
            return null;
        }
        blocked = extendedData.isBlocked;
        this.client.P().a(iconSheet);
        bbw.a((int)(x + width - 18), (int)(y + 10), (float)0.0f, (float)idx, (int)16, (int)16, (float)256.0f, (float)256.0f);
        if (blocked) {
            bbw.a((int)(x + width - 18), (int)(y + 10), (float)0.0f, (float)80.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
        return relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26 ? tooltip : null;
    }

    public String fixDescription(String description) {
        return description.endsWith(":NOFML\u00a7r") ? description.substring(0, description.length() - 8) + "\u00a7r" : description;
    }

    public void connectToServerAtStartup(String host, int port) {
        this.setupServerList();
        bjq osp = new bjq();
        bjn serverData = new bjn("Command Line", host + ":" + port);
        try {
            osp.a(serverData);
            startupConnectionData.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.showGuiScreen(new bcx((bdw)new bee(), this.client, host, port));
            return;
        }
        this.connectToServer((bdw)new bee(), serverData);
    }

    public void connectToServer(bdw guiMultiplayer, bjn serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen((Object)new GuiAccessDenied(guiMultiplayer, serverEntry));
        } else {
            this.showGuiScreen(new bcx(guiMultiplayer, this.client, serverEntry));
        }
        this.playClientBlock = new CountDownLatch(1);
    }

    public void connectToRealmsServer(String host, int port) {
        this.playClientBlock = new CountDownLatch(1);
    }

    public void setPlayClient(bjb netHandlerPlayClient) {
        if (this.playClientBlock == null) {
            this.playClientBlock = new CountDownLatch(1);
        }
        this.playClientBlock.countDown();
        this.currentPlayClient = new WeakReference<bjb>(netHandlerPlayClient);
    }

    @Override
    public void waitForPlayClient() {
        boolean gotIt = false;
        try {
            gotIt = this.playClientBlock.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!gotIt) {
            throw new RuntimeException("Timeout waiting for client thread to catch up!");
        }
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, ej manager, Set<String> channelSet, String channel, Side side) {
        if (side == Side.CLIENT) {
            this.waitForPlayClient();
            bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<bjb>(manager, channelSet, channel, side, bjb.class));
        } else {
            bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<nh>(manager, channelSet, channel, side, nh.class));
        }
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return true;
    }

    @Override
    public void allowLogins() {
    }

    public void trackMissingTexture(bqx resourceLocation) {
        this.badTextureDomains.add(resourceLocation.b());
        this.missingTextures.put((Object)resourceLocation.b(), (Object)resourceLocation);
    }

    public void trackBrokenTexture(bqx resourceLocation, String error) {
        this.badTextureDomains.add(resourceLocation.b());
        Set badType = (Set)this.brokenTextures.get((Object)resourceLocation.b(), (Object)error);
        if (badType == null) {
            badType = Sets.newHashSet();
            this.brokenTextures.put((Object)resourceLocation.b(), (Object)error, (Object)badType);
        }
        badType.add(resourceLocation);
    }

    public void logMissingTextureErrors() {
        Logger logger = LogManager.getLogger((String)"TEXTURE ERRORS");
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("The following texture errors were found.");
        Map resManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(brg.class, (brg)bao.B().Q(), "domainResourceManagers", "field_110548_a");
        for (String resourceDomain : this.missingTextures.keySet()) {
            Set missing = this.missingTextures.get((Object)resourceDomain);
            logger.error(Strings.repeat((String)"=", (int)50));
            logger.error("  DOMAIN {}", new Object[]{resourceDomain});
            logger.error(Strings.repeat((String)"-", (int)50));
            logger.error("  domain {} is missing {} texture{}", new Object[]{resourceDomain, missing.size(), missing.size() != 1 ? "s" : ""});
            bqq fallbackResourceManager = (bqq)resManagers.get(resourceDomain);
            if (fallbackResourceManager == null) {
                logger.error("    domain {} is missing a resource manager - it is probably a side-effect of automatic texture processing", new Object[]{resourceDomain});
            } else {
                List resPacks = (List)ObfuscationReflectionHelper.getPrivateValue(bqq.class, fallbackResourceManager, "resourcePacks", "field_110540_a");
                logger.error("    domain {} has {} location{}:", new Object[]{resourceDomain, resPacks.size(), resPacks.size() != 1 ? "s" : ""});
                for (bra resPack : resPacks) {
                    if (resPack instanceof FMLContainerHolder) {
                        FMLContainerHolder containerHolder = (FMLContainerHolder)resPack;
                        ModContainer fmlContainer = containerHolder.getFMLContainer();
                        logger.error("      mod {} resources at {}", new Object[]{fmlContainer.getModId(), fmlContainer.getSource().getPath()});
                        continue;
                    }
                    if (resPack instanceof bqn) {
                        bqn resourcePack = (bqn)resPack;
                        File resPath = (File)ObfuscationReflectionHelper.getPrivateValue(bqn.class, resourcePack, "resourcePackFile", "field_110597_b");
                        logger.error("      resource pack at path {}", new Object[]{resPath.getPath()});
                        continue;
                    }
                    logger.error("      unknown resourcepack type {} : {}", new Object[]{resPack.getClass().getName(), resPack.b()});
                }
            }
            logger.error(Strings.repeat((String)"-", (int)25));
            logger.error("    The missing resources for domain {} are:", new Object[]{resourceDomain});
            for (bqx rl : missing) {
                logger.error("      {}", new Object[]{rl.a()});
            }
            logger.error(Strings.repeat((String)"-", (int)25));
            if (!this.brokenTextures.containsRow((Object)resourceDomain)) {
                logger.error("    No other errors exist for domain {}", new Object[]{resourceDomain});
            } else {
                logger.error("    The following other errors were reported for domain {}:", new Object[]{resourceDomain});
                Map resourceErrs = this.brokenTextures.row((Object)resourceDomain);
                for (String error : resourceErrs.keySet()) {
                    logger.error(Strings.repeat((String)"-", (int)25));
                    logger.error("    Problem: {}", new Object[]{error});
                    for (bqx rl : (Set)resourceErrs.get(error)) {
                        logger.error("      {}", new Object[]{rl.a()});
                    }
                }
            }
            logger.error(Strings.repeat((String)"=", (int)50));
        }
        logger.error(Strings.repeat((String)"+=", (int)25));
    }
}

