/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ModAPITransformer
implements IClassTransformer {
    private static final boolean logDebugInfo = Boolean.valueOf(System.getProperty("fml.debugAPITransformer", "false"));
    private ListMultimap<String, ASMDataTable.ASMData> optionals;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (this.optionals == null || !this.optionals.containsKey((Object)name)) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        if (logDebugInfo) {
            FMLRelaunchLog.finest("Optional removal - found optionals for class %s - processing", name);
        }
        for (ASMDataTable.ASMData optional : this.optionals.get((Object)name)) {
            String modId = (String)optional.getAnnotationInfo().get("modid");
            if (Loader.isModLoaded(modId)) {
                if (!logDebugInfo) continue;
                FMLRelaunchLog.finest("Optional removal skipped - mod present %s", modId);
                continue;
            }
            if (logDebugInfo) {
                FMLRelaunchLog.finest("Optional on %s triggered - mod missing %s", name, modId);
            }
            if ("cpw.mods.fml.common.Optional$Interface".equals(optional.getAnnotationName())) {
                this.stripInterface(classNode, (String)optional.getAnnotationInfo().get("iface"));
                continue;
            }
            this.stripMethod(classNode, optional.getObjectName());
        }
        if (logDebugInfo) {
            FMLRelaunchLog.finest("Optional removal - class %s processed", name);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void stripMethod(ClassNode classNode, String methodDescriptor) {
        ListIterator iterator = classNode.methods.listIterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (!methodDescriptor.equals(method.name + method.desc)) continue;
            iterator.remove();
            if (logDebugInfo) {
                FMLRelaunchLog.finest("Optional removal - method %s removed", methodDescriptor);
            }
            return;
        }
        if (logDebugInfo) {
            FMLRelaunchLog.finest("Optional removal - method %s NOT removed - not found", methodDescriptor);
        }
    }

    private void stripInterface(ClassNode classNode, String interfaceName) {
        String ifaceName = interfaceName.replace('.', '/');
        boolean found = classNode.interfaces.remove(ifaceName);
        if (found && logDebugInfo) {
            FMLRelaunchLog.finest("Optional removal - interface %s removed", interfaceName);
        }
        if (!found && logDebugInfo) {
            FMLRelaunchLog.finest("Optional removal - interface %s NOT removed - not found", interfaceName);
        }
    }

    public void initTable(ASMDataTable dataTable) {
        this.optionals = ArrayListMultimap.create();
        Set<ASMDataTable.ASMData> interfaces = dataTable.getAll("cpw.mods.fml.common.Optional$Interface");
        this.addData(interfaces);
        Set<ASMDataTable.ASMData> methods = dataTable.getAll("cpw.mods.fml.common.Optional$Method");
        this.addData(methods);
    }

    private void addData(Set<ASMDataTable.ASMData> interfaces) {
        for (ASMDataTable.ASMData data : interfaces) {
            this.optionals.put((Object)data.getClassName(), (Object)data);
        }
    }
}

