/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.JsonField;
import argo.jdom.JsonNodeDoesNotMatchChainedJsonNodeSelectorException;
import argo.jdom.JsonNodeDoesNotMatchPathElementsException;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonNodeSelector;
import argo.jdom.JsonNodeSelectors;
import argo.jdom.JsonNodeType;
import argo.jdom.JsonStringNode;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonNode {
    JsonNode() {
    }

    public abstract JsonNodeType getType();

    public abstract String getText();

    public abstract Map<JsonStringNode, JsonNode> getFields();

    public abstract List<JsonField> getFieldList();

    public abstract List<JsonNode> getElements();

    public JsonNode getNode(Object ... pathElements) {
        return this.wrapExceptionsFor(JsonNodeSelectors.anyNode(pathElements), this, pathElements);
    }

    public final boolean isBooleanValue(Object ... pathElements) {
        return JsonNodeSelectors.aBooleanNode(pathElements).matches(this);
    }

    public final Boolean getBooleanValue(Object ... pathElements) {
        return this.wrapExceptionsFor(JsonNodeSelectors.aBooleanNode(pathElements), this, pathElements);
    }

    public final boolean isStringValue(Object ... pathElements) {
        return JsonNodeSelectors.aStringNode(pathElements).matches(this);
    }

    public final String getStringValue(Object ... pathElements) {
        return this.wrapExceptionsFor(JsonNodeSelectors.aStringNode(pathElements), this, pathElements);
    }

    public final List<JsonNode> getArrayNode(Object ... pathElements) {
        return this.wrapExceptionsFor(JsonNodeSelectors.anArrayNode(pathElements), this, pathElements);
    }

    private <T, V extends JsonNode> T wrapExceptionsFor(JsonNodeSelector<V, T> value, V node, Object[] pathElements) throws JsonNodeDoesNotMatchPathElementsException {
        try {
            return value.getValue(node);
        }
        catch (JsonNodeDoesNotMatchChainedJsonNodeSelectorException e) {
            throw JsonNodeDoesNotMatchPathElementsException.jsonNodeDoesNotMatchPathElementsException(e, pathElements, JsonNodeFactories.array(node));
        }
    }
}

