/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.BlockTracker;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;

public class GameRegistry {
    private static Multimap<ModContainer, BlockProxy> blockRegistry = ArrayListMultimap.create();
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ICraftingHandler> craftingHandlers = Lists.newArrayList();
    private static List<IPickupNotifier> pickupHandlers = Lists.newArrayList();
    private static List<IPlayerTracker> playerTrackers = Lists.newArrayList();

    public static void registerWorldGenerator(IWorldGenerator generator) {
        worldGenerators.add(generator);
    }

    public static void generateWorld(int chunkX, int chunkZ, abr world, adj chunkGenerator, adj chunkProvider) {
        long worldSeed = world.H();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        for (IWorldGenerator generator : worldGenerators) {
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public static Object buildBlock(ModContainer container, Class<?> type, Mod.Block annotation) throws Exception {
        Object o = type.getConstructor(Integer.TYPE).newInstance(GameRegistry.findSpareBlockId());
        GameRegistry.registerBlock((aqs)o);
        return o;
    }

    private static int findSpareBlockId() {
        return BlockTracker.nextBlockId();
    }

    public static void registerItem(xx item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerItem(xx item, String name, String modId) {
        GameData.setName(item, name, modId);
    }

    @Deprecated
    public static void registerBlock(aqs block) {
        GameRegistry.registerBlock(block, zc.class);
    }

    public static void registerBlock(aqs block, String name) {
        GameRegistry.registerBlock(block, zc.class, name);
    }

    @Deprecated
    public static void registerBlock(aqs block, Class<? extends zc> itemclass) {
        GameRegistry.registerBlock(block, itemclass, null);
    }

    public static void registerBlock(aqs block, Class<? extends zc> itemclass, String name) {
        GameRegistry.registerBlock(block, itemclass, name, null);
    }

    public static void registerBlock(aqs block, Class<? extends zc> itemclass, String name, String modId) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            xx i;
            assert (block != null) : "registerBlock: block cannot be null";
            assert (itemclass != null) : "registerBlock: itemclass cannot be null";
            int blockItemId = block.cF - 256;
            try {
                Constructor<? extends zc> itemCtor = itemclass.getConstructor(Integer.TYPE);
                i = (xx)itemCtor.newInstance(blockItemId);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends zc> itemCtor = itemclass.getConstructor(Integer.TYPE, aqs.class);
                i = (xx)itemCtor.newInstance(blockItemId, block);
            }
            GameRegistry.registerItem(i, name, modId);
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e);
        }
        blockRegistry.put((Object)Loader.instance().activeModContainer(), (Object)((BlockProxy)block));
    }

    public static void addRecipe(xz output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static aac addShapedRecipe(xz output, Object ... params) {
        return aaa.a().a(output, params);
    }

    public static void addShapelessRecipe(xz output, Object ... params) {
        aaa.a().b(output, params);
    }

    public static void addRecipe(aac recipe) {
        aaa.a().b().add(recipe);
    }

    public static void addSmelting(int input, xz output, float xp) {
        zw.a().a(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends asi> tileEntityClass, String id) {
        asi.a(tileEntityClass, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends asi> tileEntityClass, String id, String ... alternatives) {
        asi.a(tileEntityClass, (String)id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(asi.class, null, "field_70326_a", "field_70326_a", "a");
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void addBiome(acl biome) {
        acb.b.addNewBiome(biome);
    }

    public static void removeBiome(acl biome) {
        acb.b.removeBiome(biome);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(xz itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        craftingHandlers.add(handler);
    }

    public static void onItemCrafted(ua player, xz item, ml craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onCrafting(player, item, craftMatrix);
        }
    }

    public static void onItemSmelted(ua player, xz item) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onSmelting(player, item);
        }
    }

    public static void registerPickupHandler(IPickupNotifier handler) {
        pickupHandlers.add(handler);
    }

    public static void onPickupNotification(ua player, sp item) {
        for (IPickupNotifier notify : pickupHandlers) {
            notify.notifyPickup(item, player);
        }
    }

    public static void registerPlayerTracker(IPlayerTracker tracker) {
        playerTrackers.add(tracker);
    }

    public static void onPlayerLogin(ua player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogin(player);
        }
    }

    public static void onPlayerLogout(ua player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogout(player);
        }
    }

    public static void onPlayerChangedDimension(ua player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerChangedDimension(player);
        }
    }

    public static void onPlayerRespawn(ua player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerRespawn(player);
        }
    }

    public static aqs findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static xx findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, xz itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static xz findItemStack(String modId, String name, int stackSize) {
        xz foundStack = GameData.findItemStack(modId, name);
        if (foundStack != null) {
            xz is = foundStack.m();
            is.b = Math.min(stackSize, is.e());
            return is;
        }
        return null;
    }
}

