/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.ItemData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class GameData {
    private static Map<Integer, ItemData> idMap = Maps.newHashMap();
    private static CountDownLatch serverValidationLatch;
    private static CountDownLatch clientValidationLatch;
    private static MapDifference<Integer, ItemData> difference;
    private static boolean shouldContinue;
    private static boolean isSaveValid;
    private static ImmutableTable<String, String, Integer> modObjectTable;
    private static Table<String, String, xz> customItemStacks;
    private static Map<String, String> ignoredMods;

    private static boolean isModIgnoredForIdValidation(String modId) {
        if (ignoredMods == null) {
            File f = new File(Loader.instance().getConfigDir(), "fmlIDChecking.properties");
            if (f.exists()) {
                Properties p = new Properties();
                try {
                    p.load(new FileInputStream(f));
                    ignoredMods = Maps.fromProperties((Properties)p);
                    if (ignoredMods.size() > 0) {
                        FMLLog.log("fml.ItemTracker", Level.WARNING, "Using non-empty ignored mods configuration file %s", ignoredMods.keySet());
                    }
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                    FMLLog.log("fml.ItemTracker", Level.SEVERE, e, "Failed to read ignored ID checker mods properties file", new Object[0]);
                    ignoredMods = ImmutableMap.of();
                }
            } else {
                ignoredMods = ImmutableMap.of();
            }
        }
        return ignoredMods.containsKey(modId);
    }

    public static void newItemAdded(xx item) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null) {
            mc = Loader.instance().getMinecraftModContainer();
            if (Loader.instance().hasReachedState(LoaderState.AVAILABLE)) {
                FMLLog.severe("It appears something has tried to allocate an Item outside of the initialization phase of Minecraft, this could be very bad for your network connectivity.", new Object[0]);
            }
        }
        String itemType = item.getClass().getName();
        ItemData itemData = new ItemData(item, mc);
        if (idMap.containsKey(item.cv)) {
            ItemData id = idMap.get(item.cv);
            FMLLog.log("fml.ItemTracker", Level.INFO, "The mod %s is overwriting existing item at %d (%s from %s) with %s", mc.getModId(), id.getItemId(), id.getItemType(), id.getModId(), itemType);
        }
        idMap.put(item.cv, itemData);
        if (!"Minecraft".equals(mc.getModId())) {
            FMLLog.log("fml.ItemTracker", Level.FINE, "Adding item %s(%d) owned by %s", item.getClass().getName(), item.cv, mc.getModId());
        }
    }

    public static void validateWorldSave(Set<ItemData> worldSaveItems) {
        isSaveValid = true;
        shouldContinue = true;
        if (worldSaveItems == null) {
            serverValidationLatch.countDown();
            try {
                clientValidationLatch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return;
        }
        Function<ItemData, Integer> idMapFunction = new Function<ItemData, Integer>(){

            public Integer apply(ItemData input) {
                return input.getItemId();
            }
        };
        ImmutableMap worldMap = Maps.uniqueIndex(worldSaveItems, (Function)idMapFunction);
        difference = Maps.difference((Map)worldMap, idMap);
        FMLLog.log("fml.ItemTracker", Level.FINE, "The difference set is %s", difference);
        if (!difference.entriesDiffering().isEmpty() || !difference.entriesOnlyOnLeft().isEmpty()) {
            FMLLog.log("fml.ItemTracker", Level.SEVERE, "FML has detected item discrepancies", new Object[0]);
            FMLLog.log("fml.ItemTracker", Level.SEVERE, "Missing items : %s", difference.entriesOnlyOnLeft());
            FMLLog.log("fml.ItemTracker", Level.SEVERE, "Mismatched items : %s", difference.entriesDiffering());
            boolean foundNonIgnored = false;
            for (ItemData diff : difference.entriesOnlyOnLeft().values()) {
                if (GameData.isModIgnoredForIdValidation(diff.getModId())) continue;
                foundNonIgnored = true;
            }
            for (ItemData diff : difference.entriesDiffering().values()) {
                if (GameData.isModIgnoredForIdValidation(((ItemData)diff.leftValue()).getModId()) || GameData.isModIgnoredForIdValidation(((ItemData)diff.rightValue()).getModId())) continue;
                foundNonIgnored = true;
            }
            if (!foundNonIgnored) {
                FMLLog.log("fml.ItemTracker", Level.SEVERE, "FML is ignoring these ID discrepancies because of configuration. YOUR GAME WILL NOW PROBABLY CRASH. HOPEFULLY YOU WON'T HAVE CORRUPTED YOUR WORLD. BLAME %s", ignoredMods.keySet());
            }
            isSaveValid = !foundNonIgnored;
            serverValidationLatch.countDown();
        } else {
            isSaveValid = true;
            serverValidationLatch.countDown();
        }
        try {
            clientValidationLatch.await();
            if (!shouldContinue) {
                throw new RuntimeException("This server instance is going to stop abnormally because of a fatal ID mismatch");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void writeItemData(cf itemList) {
        for (ItemData dat : idMap.values()) {
            itemList.a((ck)dat.toNBT());
        }
    }

    public static void initializeServerGate(int gateCount) {
        serverValidationLatch = new CountDownLatch(gateCount - 1);
        clientValidationLatch = new CountDownLatch(gateCount - 1);
    }

    public static MapDifference<Integer, ItemData> gateWorldLoadingForValidation() {
        try {
            serverValidationLatch.await();
            if (!isSaveValid) {
                return difference;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        difference = null;
        return null;
    }

    public static void releaseGate(boolean carryOn) {
        shouldContinue = carryOn;
        clientValidationLatch.countDown();
    }

    public static Set<ItemData> buildWorldItemData(cf modList) {
        HashSet worldSaveItems = Sets.newHashSet();
        for (int i = 0; i < modList.c(); ++i) {
            bx mod = (bx)modList.b(i);
            ItemData dat = new ItemData(mod);
            worldSaveItems.add(dat);
        }
        return worldSaveItems;
    }

    static void setName(xx item, String name, String modId) {
        int id = item.cv;
        ItemData itemData = idMap.get(id);
        itemData.setName(name, modId);
    }

    public static void buildModObjectTable() {
        if (modObjectTable != null) {
            throw new IllegalStateException("Illegal call to buildModObjectTable!");
        }
        Map map = Maps.transformValues(idMap, (Function)new Function<ItemData, Table.Cell<String, String, Integer>>(){

            public Table.Cell<String, String, Integer> apply(ItemData data) {
                if ("Minecraft".equals(data.getModId()) || !data.isOveridden()) {
                    return null;
                }
                return Tables.immutableCell((Object)data.getModId(), (Object)data.getItemType(), (Object)data.getItemId());
            }
        });
        ImmutableTable.Builder tBuilder = ImmutableTable.builder();
        for (Table.Cell c2 : map.values()) {
            if (c2 == null) continue;
            tBuilder.put(c2);
        }
        modObjectTable = tBuilder.build();
    }

    static xx findItem(String modId, String name) {
        if (modObjectTable == null || !modObjectTable.contains((Object)modId, (Object)name)) {
            return null;
        }
        return xx.g[(Integer)modObjectTable.get((Object)modId, (Object)name)];
    }

    static aqs findBlock(String modId, String name) {
        if (modObjectTable == null) {
            return null;
        }
        Integer blockId = (Integer)modObjectTable.get((Object)modId, (Object)name);
        if (blockId == null || blockId >= aqs.s.length) {
            return null;
        }
        return aqs.s[blockId];
    }

    static xz findItemStack(String modId, String name) {
        aqs b2;
        xx i;
        xz is = (xz)customItemStacks.get((Object)modId, (Object)name);
        if (is == null && (i = GameData.findItem(modId, name)) != null) {
            is = new xz(i, 0, 0);
        }
        if (is == null && (b2 = GameData.findBlock(modId, name)) != null) {
            is = new xz(b2, 0, Short.MAX_VALUE);
        }
        return is;
    }

    static void registerCustomItemStack(String name, xz itemStack) {
        customItemStacks.put((Object)Loader.instance().activeModContainer().getModId(), (Object)name, (Object)itemStack);
    }

    public static void dumpRegistry(File minecraftDir) {
        if (customItemStacks == null) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("fml.dumpRegistry", "false")).booleanValue()) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String modId : customItemStacks.rowKeySet()) {
                builder.putAll((Object)modId, customItemStacks.row((Object)modId).keySet());
            }
            File f = new File(minecraftDir, "itemStackRegistry.csv");
            Joiner.MapJoiner mapJoiner = Joiner.on((String)"\n").withKeyValueSeparator(",");
            try {
                Files.write((CharSequence)mapJoiner.join((Iterable)builder.build().entries()), (File)f, (Charset)Charsets.UTF_8);
                FMLLog.log(Level.INFO, "Dumped item registry data to %s", f.getAbsolutePath());
            }
            catch (IOException e) {
                FMLLog.log(Level.SEVERE, e, "Failed to write registry data to %s", f.getAbsolutePath());
            }
        }
    }

    static {
        shouldContinue = true;
        isSaveValid = true;
        customItemStacks = HashBasedTable.create();
    }
}

