/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class FMLNetworkHandler {
    private static final int FML_HASH = Hashing.murmur3_32().hashString((CharSequence)"FML").asInt();
    private static final int PROTOCOL_VERSION = 2;
    private static final FMLNetworkHandler INSTANCE = new FMLNetworkHandler();
    static final int LOGIN_RECEIVED = 1;
    static final int CONNECTION_VALID = 2;
    static final int FML_OUT_OF_DATE = -1;
    static final int MISSING_MODS_OR_VERSIONS = -2;
    private Map<jv, Integer> loginStates = Maps.newHashMap();
    private Map<ModContainer, NetworkModHandler> networkModHandlers = Maps.newHashMap();
    private Map<Integer, NetworkModHandler> networkIdLookup = Maps.newHashMap();

    public static void handlePacket250Packet(dz packet, cl network, ey handler) {
        String target = packet.a;
        if (target.startsWith("MC|")) {
            handler.handleVanilla250Packet(packet);
        }
        if (target.equals("FML")) {
            FMLNetworkHandler.instance().handleFMLPacket(packet, network, handler);
        } else {
            NetworkRegistry.instance().handleCustomPacket(packet, network, handler);
        }
    }

    public static void onConnectionEstablishedToServer(ey clientHandler, cl manager, eo login) {
        NetworkRegistry.instance().clientLoggedIn(clientHandler, manager, login);
    }

    private void handleFMLPacket(dz packet, cl network, ey netHandler) {
        FMLPacket pkt = FMLPacket.readPacket(network, packet.c);
        if (pkt == null) {
            return;
        }
        String userName = "";
        if (netHandler instanceof jv) {
            userName = ((jv)netHandler).g;
        } else {
            ua pl = netHandler.getPlayer();
            if (pl != null) {
                userName = pl.c_();
            }
        }
        pkt.execute(network, this, netHandler, userName);
    }

    public static void onConnectionReceivedFromClient(jv netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        FMLNetworkHandler.instance().handleClientConnection(netLoginHandler, server, address, userName);
    }

    private void handleClientConnection(jv netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        if (!this.loginStates.containsKey(netLoginHandler)) {
            if (this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                FMLLog.fine("Connection from %s rejected - no FML packet received from client", userName);
                netLoginHandler.completeConnection("You don't have FML installed, you cannot connect to this server");
                return;
            }
            FMLLog.fine("Connection from %s was closed by vanilla minecraft", userName);
            return;
        }
        switch (this.loginStates.get(netLoginHandler)) {
            case 1: {
                String modKick = NetworkRegistry.instance().connectionReceived(netLoginHandler, (cl)netLoginHandler.a);
                if (modKick != null) {
                    netLoginHandler.completeConnection(modKick);
                    this.loginStates.remove(netLoginHandler);
                    return;
                }
                if (!this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                    this.loginStates.remove(netLoginHandler);
                    return;
                }
                jv.a((jv)netLoginHandler, (boolean)false);
                netLoginHandler.a.a((ex)this.getModListRequestPacket());
                this.loginStates.put(netLoginHandler, 2);
                break;
            }
            case 2: {
                netLoginHandler.completeConnection(null);
                this.loginStates.remove(netLoginHandler);
                break;
            }
            case -2: {
                netLoginHandler.completeConnection("The server requires mods that are absent or out of date on your client");
                this.loginStates.remove(netLoginHandler);
                break;
            }
            case -1: {
                netLoginHandler.completeConnection("Your client is not running a new enough version of FML to connect to this server");
                this.loginStates.remove(netLoginHandler);
                break;
            }
            default: {
                netLoginHandler.completeConnection("There was a problem during FML negotiation");
                this.loginStates.remove(netLoginHandler);
            }
        }
    }

    private boolean handleVanillaLoginKick(jv netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        hk playerList = server.af();
        String kickReason = playerList.a(address, userName);
        if (kickReason != null) {
            netLoginHandler.completeConnection(kickReason);
        }
        return kickReason == null;
    }

    public static void handleLoginPacketOnServer(jv handler, eo login) {
        if (login.a == FML_HASH) {
            if (login.e == 2) {
                FMLLog.finest("Received valid FML login packet from %s", handler.a.c());
                FMLNetworkHandler.instance().loginStates.put(handler, 1);
            } else if (login.e != 2) {
                FMLLog.finest("Received incorrect FML (%x) login packet from %s", login.e, handler.a.c());
                FMLNetworkHandler.instance().loginStates.put(handler, -1);
            }
        } else {
            FMLLog.fine("Received invalid login packet (%x, %x) from %s", login.a, login.e, handler.a.c());
        }
    }

    static void setHandlerState(jv handler, int state) {
        FMLNetworkHandler.instance().loginStates.put(handler, state);
    }

    public static FMLNetworkHandler instance() {
        return INSTANCE;
    }

    public static eo getFMLFakeLoginPacket() {
        FMLCommonHandler.instance().getSidedDelegate().setClientCompatibilityLevel((byte)0);
        eo fake = new eo();
        fake.a = FML_HASH;
        fake.e = 2;
        fake.d = abz.a;
        fake.b = acb.a[0];
        return fake;
    }

    public dz getModListRequestPacket() {
        return PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_REQUEST, new Object[0]));
    }

    public void registerNetworkMod(NetworkModHandler handler) {
        this.networkModHandlers.put(handler.getContainer(), handler);
        this.networkIdLookup.put(handler.getNetworkId(), handler);
    }

    public boolean registerNetworkMod(ModContainer container, Class<?> networkModClass, ASMDataTable asmData) {
        NetworkModHandler handler = new NetworkModHandler(container, networkModClass, asmData);
        if (handler.isNetworkMod()) {
            this.registerNetworkMod(handler);
        }
        return handler.isNetworkMod();
    }

    public NetworkModHandler findNetworkModHandler(Object mc) {
        if (mc instanceof InjectedModContainer) {
            return this.networkModHandlers.get(((InjectedModContainer)mc).wrappedContainer);
        }
        if (mc instanceof ModContainer) {
            return this.networkModHandlers.get(mc);
        }
        if (mc instanceof Integer) {
            return this.networkIdLookup.get(mc);
        }
        return this.networkModHandlers.get(FMLCommonHandler.instance().findContainerFor(mc));
    }

    public Set<ModContainer> getNetworkModList() {
        return this.networkModHandlers.keySet();
    }

    public static void handlePlayerLogin(js player, jx netHandler, cl manager) {
        NetworkRegistry.instance().playerLoggedIn(player, netHandler, manager);
        GameRegistry.onPlayerLogin((ua)player);
    }

    public Map<Integer, NetworkModHandler> getNetworkIdMap() {
        return this.networkIdLookup;
    }

    public void bindNetworkId(String key, Integer value) {
        Map<String, ModContainer> mods = Loader.instance().getIndexedModList();
        NetworkModHandler handler = this.findNetworkModHandler(mods.get(key));
        if (handler != null) {
            handler.setNetworkId(value);
            this.networkIdLookup.put(value, handler);
        }
    }

    public static void onClientConnectionToRemoteServer(ey netClientHandler, String server, int port, cl networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, port, networkManager);
    }

    public static void onClientConnectionToIntegratedServer(ey netClientHandler, MinecraftServer server, cl networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, networkManager);
    }

    public static void onConnectionClosed(cl manager, ua player) {
        NetworkRegistry.instance().connectionClosed(manager, player);
    }

    public static void openGui(ua player, Object mod, int modGuiId, abr world, int x, int y, int z) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mod);
            if (nmh != null) {
                mc = nmh.getContainer();
            } else {
                FMLLog.warning("A mod tried to open a gui on the server without being a NetworkMod", new Object[0]);
                return;
            }
        }
        if (player instanceof js) {
            NetworkRegistry.instance().openRemoteGui(mc, (js)player, modGuiId, world, x, y, z);
        } else {
            NetworkRegistry.instance().openLocalGui(mc, player, modGuiId, world, x, y, z);
        }
    }

    public static ex getEntitySpawningPacket(nk entity) {
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er == null) {
            return null;
        }
        if (er.usesVanillaSpawning()) {
            return null;
        }
        return PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWN, er, entity, FMLNetworkHandler.instance().findNetworkModHandler(er.getContainer())));
    }

    public static void makeEntitySpawnAdjustment(int entityId, js player, int serverX, int serverY, int serverZ) {
        dz pkt = PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWNADJUSTMENT, entityId, serverX, serverY, serverZ));
        player.a.b((ex)pkt);
    }

    public static InetAddress computeLocalHost() throws IOException {
        InetAddress add = null;
        ArrayList addresses = Lists.newArrayList();
        InetAddress localHost = InetAddress.getLocalHost();
        for (NetworkInterface ni2 : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (ni2.isLoopback() || !ni2.isUp()) continue;
            addresses.addAll(Collections.list(ni2.getInetAddresses()));
            if (!addresses.contains(localHost)) continue;
            add = localHost;
            break;
        }
        if (add == null && !addresses.isEmpty()) {
            for (InetAddress addr : addresses) {
                if (addr.getAddress().length != 4) continue;
                add = addr;
                break;
            }
        }
        if (add == null) {
            add = localHost;
        }
        return add;
    }

    public static dl handleChatMessage(ey handler, dl chat) {
        return NetworkRegistry.instance().handleChat(handler, chat);
    }

    public static void handlePacket131Packet(ey handler, dq mapData) {
        if (handler instanceof jx || mapData.a != xx.bf.cv) {
            NetworkRegistry.instance().handleTinyPacket(handler, mapData);
        } else {
            FMLCommonHandler.instance().handleTinyPacket(handler, mapData);
        }
    }

    public static int getCompatibilityLevel() {
        return 2;
    }

    public static boolean vanillaLoginPacketCompatibility() {
        return FMLCommonHandler.instance().getSidedDelegate().getClientCompatibilityLevel() == 0;
    }
}

