/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapDifference;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.network.ModMissingPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;

    private FMLServerHandler() {
        FMLCommonHandler.instance().beginLoading(this);
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
        LanguageRegistry.reloadLanguageTable();
        GameData.initializeServerGate(1);
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    @Override
    public nk spawnEntityIntoClientWorld(EntityRegistry.EntityRegistration er, EntitySpawnPacket packet) {
        return null;
    }

    @Override
    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket entitySpawnAdjustmentPacket) {
    }

    @Override
    public void sendPacket(ex packet) {
        throw new RuntimeException("You cannot send a bare packet without a target on the server!");
    }

    @Override
    public void displayMissingMods(ModMissingPacket modMissingPacket) {
    }

    @Override
    public void handleTinyPacket(ey handler, dq mapData) {
    }

    @Override
    public void setClientCompatibilityLevel(byte compatibilityLevel) {
    }

    @Override
    public byte getClientCompatibilityLevel() {
        return 0;
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    @Override
    public void disconnectIDMismatch(MapDifference<Integer, ItemData> s, ey handler, cl mgr) {
    }
}

