/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.repackage.com.nothome.delta;

import cpw.mods.fml.repackage.com.nothome.delta.ByteBufferSeekableSource;
import cpw.mods.fml.repackage.com.nothome.delta.Checksum;
import cpw.mods.fml.repackage.com.nothome.delta.DebugDiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.DiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.GDiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.RandomAccessFileSeekableSource;
import cpw.mods.fml.repackage.com.nothome.delta.SeekableSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class Delta {
    static final boolean debug = false;
    public static final int DEFAULT_CHUNK_SIZE = 16;
    private int S;
    private SourceState source;
    private TargetState target;
    private DiffWriter output;

    public Delta() {
        this.setChunkSize(16);
    }

    public void setChunkSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size");
        }
        this.S = size;
    }

    public void compute(byte[] source, byte[] target, OutputStream output) throws IOException {
        this.compute(new ByteBufferSeekableSource(source), (InputStream)new ByteArrayInputStream(target), (DiffWriter)new GDiffWriter(output));
    }

    public byte[] compute(byte[] source, byte[] target) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.compute(source, target, os);
        return os.toByteArray();
    }

    public void compute(byte[] sourceBytes, InputStream inputStream, DiffWriter diffWriter) throws IOException {
        this.compute(new ByteBufferSeekableSource(sourceBytes), inputStream, diffWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(File sourceFile, File targetFile, DiffWriter output) throws IOException {
        RandomAccessFileSeekableSource source = new RandomAccessFileSeekableSource(new RandomAccessFile(sourceFile, "r"));
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(targetFile));
        try {
            this.compute(source, (InputStream)is, output);
        }
        finally {
            source.close();
            ((InputStream)is).close();
        }
    }

    public void compute(SeekableSource seekSource, InputStream targetIS, DiffWriter output) throws IOException {
        this.source = new SourceState(seekSource);
        this.target = new TargetState(targetIS);
        this.output = output;
        while (!this.target.eof()) {
            this.debug("!target.eof()");
            int index = this.target.find(this.source);
            if (index != -1) {
                long offset = (long)index * (long)this.S;
                this.source.seek(offset);
                int match = this.target.longestMatch(this.source);
                if (match >= this.S) {
                    output.addCopy(offset, match);
                    continue;
                }
                this.target.tbuf.position(this.target.tbuf.position() - match);
                this.addData();
                continue;
            }
            this.addData();
        }
        output.close();
    }

    private void addData() throws IOException {
        int i = this.target.read();
        if (i == -1) {
            return;
        }
        this.output.addData((byte)i);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println("usage Delta [-d] source target [output]");
            System.err.println("either -d or an output filename must be specified.");
            System.err.println("aborting..");
            return;
        }
        DiffWriter output = null;
        File sourceFile = null;
        File targetFile = null;
        if (argv[0].equals("-d")) {
            sourceFile = new File(argv[1]);
            targetFile = new File(argv[2]);
            output = new DebugDiffWriter();
        } else {
            sourceFile = new File(argv[0]);
            targetFile = new File(argv[1]);
            output = new GDiffWriter(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(argv[2])))));
        }
        if (sourceFile.length() > Integer.MAX_VALUE || targetFile.length() > Integer.MAX_VALUE) {
            System.err.println("source or target is too large, max length is 2147483647");
            System.err.println("aborting..");
            return;
        }
        Delta d = new Delta();
        d.compute(sourceFile, targetFile, output);
        output.flush();
        output.close();
    }

    private void debug(String s) {
    }

    class TargetState {
        private ReadableByteChannel c;
        private ByteBuffer tbuf = ByteBuffer.allocate(this.blocksize());
        private ByteBuffer sbuf = ByteBuffer.allocate(this.blocksize());
        private long hash;
        private boolean hashReset = true;
        private boolean eof;

        TargetState(InputStream targetIS) throws IOException {
            this.c = Channels.newChannel(targetIS);
            this.tbuf.limit(0);
        }

        private int blocksize() {
            return Math.min(16384, Delta.this.S * 4);
        }

        public int find(SourceState source) throws IOException {
            if (this.eof) {
                return -1;
            }
            this.sbuf.clear();
            this.sbuf.limit(0);
            if (this.hashReset) {
                Delta.this.debug("hashReset");
                while (this.tbuf.remaining() < Delta.this.S) {
                    this.tbuf.compact();
                    int read = this.c.read(this.tbuf);
                    this.tbuf.flip();
                    if (read != -1) continue;
                    Delta.this.debug("target ending");
                    return -1;
                }
                this.hash = Checksum.queryChecksum(this.tbuf, Delta.this.S);
                this.hashReset = false;
            }
            return source.checksum.findChecksumIndex(this.hash);
        }

        public boolean eof() {
            return this.eof;
        }

        public int read() throws IOException {
            if (this.tbuf.remaining() <= Delta.this.S) {
                this.readMore();
                if (!this.tbuf.hasRemaining()) {
                    this.eof = true;
                    return -1;
                }
            }
            byte b2 = this.tbuf.get();
            if (this.tbuf.remaining() >= Delta.this.S) {
                byte nchar = this.tbuf.get(this.tbuf.position() + Delta.this.S - 1);
                this.hash = Checksum.incrementChecksum(this.hash, b2, nchar, Delta.this.S);
            } else {
                Delta.this.debug("out of char");
            }
            return b2 & 0xFF;
        }

        public int longestMatch(SourceState source) throws IOException {
            Delta.this.debug("longestMatch");
            int match = 0;
            this.hashReset = true;
            while (true) {
                if (!this.sbuf.hasRemaining()) {
                    this.sbuf.clear();
                    int read = source.source.read(this.sbuf);
                    this.sbuf.flip();
                    if (read == -1) {
                        return match;
                    }
                }
                if (!this.tbuf.hasRemaining()) {
                    this.readMore();
                    if (!this.tbuf.hasRemaining()) {
                        Delta.this.debug("target ending");
                        this.eof = true;
                        return match;
                    }
                }
                if (this.sbuf.get() != this.tbuf.get()) {
                    this.tbuf.position(this.tbuf.position() - 1);
                    return match;
                }
                ++match;
            }
        }

        private void readMore() throws IOException {
            this.tbuf.compact();
            this.c.read(this.tbuf);
            this.tbuf.flip();
        }

        void hash() {
            this.hash = Checksum.queryChecksum(this.tbuf, Delta.this.S);
        }

        public String toString() {
            return "Target[ targetBuff=" + this.dump() + " sourceBuff=" + this.sbuf + " hashf=" + this.hash + " eof=" + this.eof + "]";
        }

        private String dump() {
            return this.dump(this.tbuf);
        }

        private String dump(ByteBuffer bb) {
            return this.getTextDump(bb);
        }

        private void append(StringBuffer sb, int value) {
            char b1 = (char)(value >> 4 & 0xF);
            char b2 = (char)(value & 0xF);
            sb.append(Character.forDigit(b1, 16));
            sb.append(Character.forDigit(b2, 16));
        }

        public String getTextDump(ByteBuffer bb) {
            StringBuffer sb = new StringBuffer(bb.remaining() * 2);
            bb.mark();
            while (bb.hasRemaining()) {
                byte val = bb.get();
                if (val > 32 && val < 127) {
                    sb.append(" ").append((char)val);
                    continue;
                }
                this.append(sb, val);
            }
            bb.reset();
            return sb.toString();
        }
    }

    class SourceState {
        private Checksum checksum;
        private SeekableSource source;

        public SourceState(SeekableSource source) throws IOException {
            this.checksum = new Checksum(source, Delta.this.S);
            this.source = source;
            source.seek(0L);
        }

        public void seek(long index) throws IOException {
            this.source.seek(index);
        }

        public String toString() {
            return "Source checksum=" + this.checksum + " source=" + this.source + "";
        }
    }
}

