/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.ILibrarySet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class CoreModManager {
    private static String[] rootPlugins = new String[]{"cpw.mods.fml.relauncher.FMLCorePlugin", "net.minecraftforge.classloading.FMLForgePlugin"};
    private static List<String> loadedLibraries = new ArrayList<String>();
    private static Map<IFMLLoadingPlugin, File> pluginLocations;
    private static List<IFMLLoadingPlugin> loadPlugins;
    private static List<ILibrarySet> libraries;
    private static boolean deobfuscatedEnvironment;

    public static void handleLaunch(File mcDir, LaunchClassLoader classLoader) {
        try {
            byte[] bs = classLoader.getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                deobfuscatedEnvironment = true;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (!deobfuscatedEnvironment) {
            FMLRelaunchLog.fine("Enabling runtime deobfuscation", new Object[0]);
        }
        pluginLocations = new HashMap<IFMLLoadingPlugin, File>();
        loadPlugins = new ArrayList<IFMLLoadingPlugin>();
        for (String s : rootPlugins) {
            try {
                FMLRelaunchLog.finest("Adding coremod for loading %s", s);
                IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)Class.forName(s, true, (ClassLoader)classLoader).newInstance();
                loadPlugins.add(plugin);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (loadPlugins.isEmpty()) {
            throw new RuntimeException("A fatal error has occured - no valid fml load plugin was found - this is a completely corrupt FML installation.");
        }
        FMLRelaunchLog.fine("All core mods are successfully located", new Object[0]);
        String commandLineCoremods = System.getProperty("fml.coreMods.load", "");
        for (String s : commandLineCoremods.split(",")) {
            if (s.isEmpty()) continue;
            FMLRelaunchLog.info("Found a command line coremod : %s", s);
            try {
                classLoader.addTransformerExclusion(s);
                Class<?> coreModClass = Class.forName(s, true, (ClassLoader)classLoader);
                IFMLLoadingPlugin.TransformerExclusions trExclusions = coreModClass.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class);
                if (trExclusions != null) {
                    for (String st : trExclusions.value()) {
                        classLoader.addTransformerExclusion(st);
                    }
                }
                IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClass.newInstance();
                loadPlugins.add(plugin);
                if (plugin.getLibraryRequestClass() == null) continue;
                for (String libName : plugin.getLibraryRequestClass()) {
                    libraries.add((ILibrarySet)Class.forName(libName, true, (ClassLoader)classLoader).newInstance());
                }
            }
            catch (Throwable e) {
                FMLRelaunchLog.log(Level.SEVERE, e, "Exception occured trying to load coremod %s", s);
                throw new RuntimeException(e);
            }
        }
        CoreModManager.discoverCoreMods(mcDir, classLoader, loadPlugins, libraries);
        for (IFMLLoadingPlugin plug : loadPlugins) {
            if (plug.getASMTransformerClass() == null) continue;
            for (String xformClass : plug.getASMTransformerClass()) {
                FMLRelaunchLog.finest("Registering transformer %s", xformClass);
                classLoader.registerTransformer(xformClass);
            }
        }
        if (!deobfuscatedEnvironment) {
            classLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer");
        }
        FMLRelaunchLog.fine("Running coremod plugins", new Object[0]);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("mcLocation", mcDir);
        data.put("coremodList", loadPlugins);
        data.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
        for (IFMLLoadingPlugin plugin : loadPlugins) {
            FMLRelaunchLog.fine("Running coremod plugin %s", plugin.getClass().getSimpleName());
            data.put("coremodLocation", pluginLocations.get(plugin));
            plugin.injectData(data);
            String setupClass = plugin.getSetupClass();
            if (setupClass != null) {
                try {
                    IFMLCallHook call = (IFMLCallHook)Class.forName(setupClass, true, (ClassLoader)classLoader).newInstance();
                    HashMap<String, Object> callData = new HashMap<String, Object>();
                    callData.put("mcLocation", mcDir);
                    callData.put("classLoader", classLoader);
                    callData.put("coremodLocation", pluginLocations.get(plugin));
                    callData.put("deobfuscationFileName", FMLInjectionData.debfuscationDataName());
                    call.injectData(callData);
                    call.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            FMLRelaunchLog.fine("Coremod plugin %s run successfully", plugin.getClass().getSimpleName());
            String modContainer = plugin.getModContainerClass();
            if (modContainer == null) continue;
            FMLInjectionData.containers.add(modContainer);
        }
        try {
            FMLRelaunchLog.fine("Validating minecraft", new Object[0]);
            Class<?> loaderClazz = Class.forName("cpw.mods.fml.common.Loader", true, (ClassLoader)classLoader);
            Method m2 = loaderClazz.getMethod("injectData", Object[].class);
            m2.invoke(null, new Object[]{FMLInjectionData.data()});
            m2 = loaderClazz.getMethod("instance", new Class[0]);
            m2.invoke(null, new Object[0]);
            FMLRelaunchLog.fine("Minecraft validated, launching...", new Object[0]);
        }
        catch (Exception e) {
            System.out.println("A CRITICAL PROBLEM OCCURED INITIALIZING MINECRAFT - LIKELY YOU HAVE AN INCORRECT VERSION FOR THIS FML");
            throw new RuntimeException(e);
        }
    }

    private static void discoverCoreMods(File mcDir, LaunchClassLoader classLoader, List<IFMLLoadingPlugin> loadPlugins, List<ILibrarySet> libraries) {
        FMLRelaunchLog.fine("Discovering coremods", new Object[0]);
        File coreMods = CoreModManager.setupCoreModDir(mcDir);
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        Object[] coreModList = coreMods.listFiles(ff);
        Arrays.sort(coreModList);
        for (Object coreMod : coreModList) {
            Attributes mfAttributes;
            FMLRelaunchLog.fine("Found a candidate coremod %s", ((File)coreMod).getName());
            try {
                JarFile jar = new JarFile((File)coreMod);
                if (jar.getManifest() == null) {
                    FMLRelaunchLog.warning("Found an un-manifested jar file in the coremods folder : %s, it will be ignored.", ((File)coreMod).getName());
                    continue;
                }
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log(Level.SEVERE, ioe, "Unable to read the coremod jar file %s - ignoring", ((File)coreMod).getName());
                continue;
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                FMLRelaunchLog.severe("The coremod %s does not contain a valid jar manifest- it will be ignored", ((File)coreMod).getName());
                continue;
            }
            try {
                classLoader.addURL(((File)coreMod).toURI().toURL());
            }
            catch (MalformedURLException e) {
                FMLRelaunchLog.log(Level.SEVERE, e, "Unable to convert file into a URL. weird", new Object[0]);
                continue;
            }
            try {
                IFMLLoadingPlugin.TransformerExclusions trExclusions;
                FMLRelaunchLog.fine("Loading coremod %s", ((File)coreMod).getName());
                classLoader.addTransformerExclusion(fmlCorePlugin);
                Class<?> coreModClass = Class.forName(fmlCorePlugin, true, (ClassLoader)classLoader);
                IFMLLoadingPlugin.MCVersion requiredMCVersion = coreModClass.getAnnotation(IFMLLoadingPlugin.MCVersion.class);
                String version = "";
                if (requiredMCVersion == null) {
                    FMLRelaunchLog.log(Level.WARNING, "The coremod %s does not have a MCVersion annotation, it may cause issues with this version of Minecraft", fmlCorePlugin);
                } else {
                    version = requiredMCVersion.value();
                }
                if (!"".equals(version) && !FMLInjectionData.mccversion.equals(version)) {
                    FMLRelaunchLog.log(Level.SEVERE, "The coremod %s is requesting minecraft version %s and minecraft is %s. It will be ignored.", fmlCorePlugin, version, FMLInjectionData.mccversion);
                    continue;
                }
                if (!"".equals(version)) {
                    FMLRelaunchLog.log(Level.FINE, "The coremod %s requested minecraft version %s and minecraft is %s. It will be loaded.", fmlCorePlugin, version, FMLInjectionData.mccversion);
                }
                if ((trExclusions = coreModClass.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class)) != null) {
                    for (String st : trExclusions.value()) {
                        classLoader.addTransformerExclusion(st);
                    }
                }
                IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClass.newInstance();
                loadPlugins.add(plugin);
                pluginLocations.put(plugin, (File)coreMod);
                if (plugin.getLibraryRequestClass() != null) {
                    for (String libName : plugin.getLibraryRequestClass()) {
                        libraries.add((ILibrarySet)Class.forName(libName, true, (ClassLoader)classLoader).newInstance());
                    }
                }
                FMLRelaunchLog.fine("Loaded coremod %s", ((File)coreMod).getName());
            }
            catch (ClassNotFoundException cnfe) {
                FMLRelaunchLog.log(Level.SEVERE, cnfe, "Coremod %s: Unable to class load the plugin %s", ((File)coreMod).getName(), fmlCorePlugin);
            }
            catch (ClassCastException cce) {
                FMLRelaunchLog.log(Level.SEVERE, cce, "Coremod %s: The plugin %s is not an implementor of IFMLLoadingPlugin", ((File)coreMod).getName(), fmlCorePlugin);
            }
            catch (InstantiationException ie) {
                FMLRelaunchLog.log(Level.SEVERE, ie, "Coremod %s: The plugin class %s was not instantiable", ((File)coreMod).getName(), fmlCorePlugin);
            }
            catch (IllegalAccessException iae) {
                FMLRelaunchLog.log(Level.SEVERE, iae, "Coremod %s: The plugin class %s was not accessible", ((File)coreMod).getName(), fmlCorePlugin);
            }
        }
    }

    private static File setupCoreModDir(File mcDir) {
        File coreModDir = new File(mcDir, "coremods");
        try {
            coreModDir = coreModDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to canonicalize the coremod dir at %s", mcDir.getName()), e);
        }
        if (!coreModDir.exists()) {
            coreModDir.mkdir();
        } else if (coreModDir.exists() && !coreModDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a coremod file in %s that's not a directory", mcDir.getName()));
        }
        return coreModDir;
    }

    public static List<String> getLibraries() {
        return loadedLibraries;
    }
}

