/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

public class EntitySpawnPacket
extends FMLPacket {
    public int networkId;
    public int modEntityId;
    public int entityId;
    public double scaledX;
    public double scaledY;
    public double scaledZ;
    public float scaledYaw;
    public float scaledPitch;
    public float scaledHeadYaw;
    public List metadata;
    public int throwerId;
    public double speedScaledX;
    public double speedScaledY;
    public double speedScaledZ;
    public ByteArrayDataInput dataStream;
    public int rawX;
    public int rawY;
    public int rawZ;

    public EntitySpawnPacket() {
        super(FMLPacket.Type.ENTITYSPAWN);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        EntityRegistry.EntityRegistration er = (EntityRegistry.EntityRegistration)data[0];
        nk ent = (nk)data[1];
        NetworkModHandler handler = (NetworkModHandler)data[2];
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        dat.writeInt(handler.getNetworkId());
        dat.writeInt(er.getModEntityId());
        dat.writeInt(ent.k);
        dat.writeInt(lp.c((double)(ent.u * 32.0)));
        dat.writeInt(lp.c((double)(ent.v * 32.0)));
        dat.writeInt(lp.c((double)(ent.w * 32.0)));
        dat.writeByte((int)((byte)(ent.A * 256.0f / 360.0f)));
        dat.writeByte((int)((byte)(ent.B * 256.0f / 360.0f)));
        if (ent instanceof od) {
            dat.writeByte((int)((byte)(((od)ent).aP * 256.0f / 360.0f)));
        } else {
            dat.writeByte(0);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            ent.u().a((DataOutput)dos);
        }
        catch (IOException e) {
            // empty catch block
        }
        dat.write(bos.toByteArray());
        if (ent instanceof IThrowableEntity) {
            nk owner = ((IThrowableEntity)ent).getThrower();
            dat.writeInt(owner == null ? ent.k : owner.k);
            double maxVel = 3.9;
            double mX = ent.x;
            double mY = ent.y;
            double mZ = ent.z;
            if (mX < -maxVel) {
                mX = -maxVel;
            }
            if (mY < -maxVel) {
                mY = -maxVel;
            }
            if (mZ < -maxVel) {
                mZ = -maxVel;
            }
            if (mX > maxVel) {
                mX = maxVel;
            }
            if (mY > maxVel) {
                mY = maxVel;
            }
            if (mZ > maxVel) {
                mZ = maxVel;
            }
            dat.writeInt((int)(mX * 8000.0));
            dat.writeInt((int)(mY * 8000.0));
            dat.writeInt((int)(mZ * 8000.0));
        } else {
            dat.writeInt(0);
        }
        if (ent instanceof IEntityAdditionalSpawnData) {
            ((IEntityAdditionalSpawnData)ent).writeSpawnData(dat);
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        this.networkId = dat.readInt();
        this.modEntityId = dat.readInt();
        this.entityId = dat.readInt();
        this.rawX = dat.readInt();
        this.rawY = dat.readInt();
        this.rawZ = dat.readInt();
        this.scaledX = (double)this.rawX / 32.0;
        this.scaledY = (double)this.rawY / 32.0;
        this.scaledZ = (double)this.rawZ / 32.0;
        this.scaledYaw = (float)dat.readByte() * 360.0f / 256.0f;
        this.scaledPitch = (float)dat.readByte() * 360.0f / 256.0f;
        this.scaledHeadYaw = (float)dat.readByte() * 360.0f / 256.0f;
        ByteArrayInputStream bis2 = new ByteArrayInputStream(data, 27, data.length - 27);
        DataInputStream dis = new DataInputStream(bis2);
        try {
            this.metadata = ol.a((DataInput)dis);
        }
        catch (IOException e) {
            // empty catch block
        }
        dat.skipBytes(data.length - bis2.available() - 27);
        this.throwerId = dat.readInt();
        if (this.throwerId != 0) {
            this.speedScaledX = (double)dat.readInt() / 8000.0;
            this.speedScaledY = (double)dat.readInt() / 8000.0;
            this.speedScaledZ = (double)dat.readInt() / 8000.0;
        }
        this.dataStream = dat;
        return this;
    }

    @Override
    public void execute(cl network, FMLNetworkHandler handler, ey netHandler, String userName) {
        NetworkModHandler nmh = handler.findNetworkModHandler(this.networkId);
        ModContainer mc = nmh.getContainer();
        EntityRegistry.EntityRegistration registration = EntityRegistry.instance().lookupModSpawn(mc, this.modEntityId);
        if (registration == null || registration.getEntityClass() == null) {
            FMLLog.log(Level.WARNING, "Missing mod entity information for %s : %d", mc.getModId(), this.modEntityId);
            return;
        }
        nk entity = FMLCommonHandler.instance().spawnEntityIntoClientWorld(registration, this);
    }
}

