/*
 * The FML Forge Mod Loader suite.
 * Copyright (C) 2012 cpw
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

package cpw.mods.fml.client;

import net.minecraft.client.renderer.texturefx.TextureFX;

class OverrideInfo
{
    public String texture;
    public String override;
    public int index;
    public int imageIndex;
    public TextureFX textureFX;
    public boolean added;
    
    @Override
    public boolean equals(Object obj)
    {
        try {
            OverrideInfo inf=(OverrideInfo) obj;
            return index==inf.index && imageIndex==inf.imageIndex;
        } catch (Exception e) {
            return false;
        }
    }
    
    @Override
    public int hashCode()
    {
        return index+imageIndex;
    }
}