/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructMember {
    protected int accessFlags;
    protected VBStyleCollection<StructGeneralAttribute, String> attributes;

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public VBStyleCollection<StructGeneralAttribute, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasModifier(int modifier) {
        return (this.accessFlags & modifier) == modifier;
    }

    public boolean isSynthetic() {
        return this.hasModifier(4096) || this.attributes.containsKey("Synthetic");
    }

    protected VBStyleCollection<StructGeneralAttribute, String> readAttributes(DataInputFullStream in, ConstantPool pool) throws IOException {
        VBStyleCollection<StructGeneralAttribute, String> attributes = new VBStyleCollection<StructGeneralAttribute, String>();
        int length = in.readUnsignedShort();
        for (int i = 0; i < length; ++i) {
            StructLocalVariableTableAttribute table;
            int nameIndex = in.readUnsignedShort();
            String name = pool.getPrimitiveConstant(nameIndex).getString();
            StructGeneralAttribute attribute = this.readAttribute(in, pool, name);
            if (attribute == null) continue;
            if (("LocalVariableTable".equals(name) || "LocalVariableTypeTable".equals(name)) && attributes.containsKey("LocalVariableTable")) {
                table = (StructLocalVariableTableAttribute)attributes.getWithKey("LocalVariableTable");
                table.addLocalVariableTable((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            if ("LocalVariableTable".equals(name) && attributes.containsKey("LocalVariableTypeTable")) {
                StructLocalVariableTableAttribute lvtt = (StructLocalVariableTableAttribute)attributes.getWithKey("LocalVariableTypeTable");
                ((StructLocalVariableTableAttribute)attribute).addLocalVariableTable(lvtt);
                attributes.addWithKey(attribute, attribute.getName());
                continue;
            }
            if ("LocalVariableTypeTable".equals(name) && attributes.containsKey("LocalVariableTypeTable")) {
                table = (StructLocalVariableTableAttribute)attributes.getWithKey("LocalVariableTypeTable");
                table.addLocalVariableTable((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            attributes.addWithKey(attribute, attribute.getName());
        }
        return attributes;
    }

    protected StructGeneralAttribute readAttribute(DataInputFullStream in, ConstantPool pool, String name) throws IOException {
        StructGeneralAttribute attribute = StructGeneralAttribute.createAttribute(name);
        if (attribute == null) {
            in.discard(in.readInt());
        } else {
            byte[] data = new byte[in.readInt()];
            in.readFull(data);
            attribute.setInfo(data);
            attribute.initContent(pool);
        }
        return attribute;
    }
}

