/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.vars.StartEndPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class LVTVariable
implements Comparable<LVTVariable> {
    public static final Comparator<LVTVariable> INDEX_SORTER = new Comparator<LVTVariable>(){

        @Override
        public int compare(LVTVariable o1, LVTVariable o2) {
            if (o1.index != o2.index) {
                return o1.index - o2.index;
            }
            if (o1.start != o2.start) {
                return o1.start - o2.start;
            }
            return o1.end - o2.end;
        }
    };
    public final String name;
    public final int start;
    public final int end;
    public final int index;
    private String desc;
    private String sig;
    private boolean isLVTT;

    public LVTVariable(String name, String desc, int start, int end, int index, boolean isLVTT) {
        this.name = name;
        this.desc = desc;
        this.start = start;
        this.end = end;
        this.index = index;
        this.isLVTT = isLVTT;
    }

    void merge(LVTVariable other) {
        if (other.isLVTT && this.sig == null) {
            this.sig = other.desc;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LVTVariable)) {
            return false;
        }
        return ((LVTVariable)obj).index == this.index && ((LVTVariable)obj).end == this.end;
    }

    public int hashCode() {
        return this.index * 31 + this.end;
    }

    public void addTo(Map<StartEndPair, Set<LVTVariable>> endpoints) {
        StartEndPair sepair = new StartEndPair(this.start, this.end);
        Set<LVTVariable> ends = endpoints.get(sepair);
        if (ends == null) {
            ends = new HashSet<LVTVariable>();
            endpoints.put(sepair, ends);
        }
        ends.add(this);
    }

    @Override
    public int compareTo(LVTVariable o) {
        if (o.end > this.end) {
            return -1;
        }
        if (o.end < this.end) {
            return 1;
        }
        if (o.index > this.index) {
            return -1;
        }
        if (o.index < this.index) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "'(" + this.index + "," + this.end + ")" + this.desc + (this.sig != null ? "<" + this.sig + "> " : " ") + this.name + "'";
    }

    public String getDesc() {
        return this.desc;
    }

    public String getSig() {
        return this.sig;
    }

    public VarType getVarType() {
        return new VarType(this.desc);
    }

    public LVTVariable rename(String newName) {
        return new LVTVariable(newName, this.desc, this.start, this.end, this.index, this.isLVTT);
    }
}

