/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextUtil;

public class InvocationExprent
extends Exprent {
    public static final int INVOKE_SPECIAL = 1;
    public static final int INVOKE_VIRTUAL = 2;
    public static final int INVOKE_STATIC = 3;
    public static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_DYNAMIC = 5;
    public static final int TYP_GENERAL = 1;
    public static final int TYP_INIT = 2;
    public static final int TYP_CLINIT = 3;
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private String name;
    private String classname;
    private boolean isStatic;
    private int functype = 1;
    private Exprent instance;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invokeDynamicClassSuffix;
    private int invocationTyp = 2;
    private List<Exprent> lstParameters = new ArrayList<Exprent>();
    private List<VarType> genericArgs = new ArrayList<VarType>();

    public InvocationExprent() {
        super(8);
    }

    public InvocationExprent(int opcode, LinkConstant cn, ListStack<Exprent> stack, int dynamicInvocationType, BitSet bytecodeOffsets) {
        this();
        this.name = cn.elementname;
        this.classname = cn.classname;
        switch (opcode) {
            case 184: {
                this.invocationTyp = 3;
                break;
            }
            case 183: {
                this.invocationTyp = 1;
                break;
            }
            case 182: {
                this.invocationTyp = 2;
                break;
            }
            case 185: {
                this.invocationTyp = 4;
                break;
            }
            case 186: {
                this.invocationTyp = 5;
                this.classname = "java/lang/Class";
                this.invokeDynamicClassSuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.functype = 2;
        } else if ("<clinit>".equals(this.name)) {
            this.functype = 3;
        }
        this.stringDescriptor = cn.descriptor;
        this.descriptor = MethodDescriptor.parseDescriptor(cn.descriptor);
        for (VarType ignored : this.descriptor.params) {
            this.lstParameters.add(0, stack.pop());
        }
        if (opcode == 186) {
            if (dynamicInvocationType == 6) {
                this.isStatic = true;
            } else if (!this.lstParameters.isEmpty()) {
                this.instance = this.lstParameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private InvocationExprent(InvocationExprent expr) {
        this();
        this.name = expr.getName();
        this.classname = expr.getClassname();
        this.isStatic = expr.isStatic();
        this.functype = expr.getFunctype();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationTyp = expr.getInvocationTyp();
        this.invokeDynamicClassSuffix = expr.getInvokeDynamicClassSuffix();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        this.lstParameters = new ArrayList<Exprent>(expr.getLstParameters());
        ExprProcessor.copyEntries(this.lstParameters);
        this.addBytecodeOffsets(expr.bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        List<StructMethod> matches = this.getMatchedDescriptors();
        StructMethod desc = null;
        if (matches.size() == 1) {
            desc = matches.get(0);
        }
        VarType type = this.getExprType();
        this.genericArgs.clear();
        if (desc != null && desc.getSignature() != null) {
            VarType newType;
            VarType ret = desc.getSignature().ret;
            HashMap<VarType, VarType> map = new HashMap<VarType, VarType>();
            if (upperBound != null && upperBound.isGeneric() && ret.isGeneric()) {
                List<VarType> leftArgs = ((GenericType)upperBound).getArguments();
                List<VarType> rightArgs = ((GenericType)ret).getArguments();
                List<String> fparams = desc.getSignature().fparameters;
                if (leftArgs.size() == rightArgs.size() && rightArgs.size() == fparams.size()) {
                    for (int i = 0; i < leftArgs.size(); ++i) {
                        VarType l = leftArgs.get(i);
                        VarType r = rightArgs.get(i);
                        if (l == null || !r.value.equals(fparams.get(i))) {
                            this.genericArgs.clear();
                            map.clear();
                            break;
                        }
                        this.genericArgs.add(l);
                        map.put(r, l);
                    }
                }
            }
            if (!map.isEmpty() && ret != (newType = ret.remap(map))) {
                return newType;
            }
            return ret;
        }
        return type;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            Exprent parameter = this.lstParameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.typeFamily));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.lstParameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        int start;
        GenericType genType;
        ClassesProcessor.ClassNode newNode;
        TextBuffer buf = new TextBuffer();
        String super_qualifier = null;
        boolean isInstanceThis = false;
        tracer.addMapping(this.bytecode);
        if (this.isStatic) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.classname)));
            }
        } else {
            if (this.instance != null && this.instance.type == 12) {
                MethodWrapper current_meth;
                VarExprent instvar = (VarExprent)this.instance;
                VarVersionPair varpaar = new VarVersionPair(instvar);
                VarProcessor vproc = instvar.getProcessor();
                if (vproc == null && (current_meth = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
                    vproc = current_meth.varproc;
                }
                String this_classname = null;
                if (vproc != null) {
                    this_classname = vproc.getThisVars().get(varpaar);
                }
                if (this_classname != null) {
                    isInstanceThis = true;
                    if (this.invocationTyp == 1 && !this.classname.equals(this_classname)) {
                        super_qualifier = this_classname;
                    }
                }
            }
            if (this.functype == 1) {
                if (super_qualifier != null) {
                    TextUtil.writeQualifiedSuper(buf, super_qualifier);
                } else if (this.instance != null) {
                    TextBuffer res = this.instance.toJava(indent, tracer);
                    VarType rightType = this.instance.getExprType();
                    VarType leftType = new VarType(8, 0, this.classname);
                    if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType)) {
                        buf.append("((").append(ExprProcessor.getCastTypeName(leftType)).append(")");
                        if (this.instance.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                            res.enclose("(", ")");
                        }
                        buf.append(res).append(")");
                    } else if (this.instance.getPrecedence() > this.getPrecedence()) {
                        buf.append("(").append(res).append(")");
                    } else {
                        buf.append(res);
                    }
                }
            }
        }
        switch (this.functype) {
            case 1: {
                if ("<VAR_NAMELESS_ENCLOSURE>".equals(buf.toString())) {
                    buf = new TextBuffer();
                }
                if (buf.length() > 0) {
                    buf.append(".");
                    if (this.genericArgs.size() != 0) {
                        buf.append("<");
                        for (int i = 0; i < this.genericArgs.size(); ++i) {
                            buf.append(ExprProcessor.getCastTypeName(this.genericArgs.get(i)));
                            if (i + 1 >= this.genericArgs.size()) continue;
                            buf.append(", ");
                        }
                        buf.append(">");
                    }
                }
                buf.append(this.name);
                if (this.invocationTyp == 5) {
                    buf.append("<invokedynamic>");
                }
                buf.append("(");
                break;
            }
            case 3: {
                throw new RuntimeException("Explicit invocation of <clinit>");
            }
            case 2: {
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                throw new RuntimeException("Unrecognized invocation of <init>");
            }
        }
        List<VarVersionPair> sigFields = null;
        boolean isEnum = false;
        if (this.functype == 2 && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname)) != null) {
            if (newNode.getWrapper() != null) {
                sigFields = newNode.getWrapper().getMethodWrapper((String)"<init>", (String)this.stringDescriptor).signatureFields;
            } else if (newNode.type == 1 && (newNode.access & 8) == 0) {
                sigFields = new ArrayList<VarVersionPair>(Collections.nCopies(this.lstParameters.size(), null));
                sigFields.set(0, new VarVersionPair(-1, 0));
            }
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("den");
        }
        List<StructMethod> matches = this.getMatchedDescriptors();
        BitSet setAmbiguousParameters = this.getAmbiguousParameters(matches);
        StructMethod desc = null;
        if (matches.size() == 1) {
            desc = matches.get(0);
        }
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        HashMap<VarType, VarType> genArgs = new HashMap<VarType, VarType>();
        if (cl != null && cl.getSignature() != null && this.instance != null && this.instance.getInferredExprType(null).isGeneric() && (genType = (GenericType)this.instance.getInferredExprType(null)).getArguments().size() == cl.getSignature().fparameters.size()) {
            for (int i = 0; i < cl.getSignature().fparameters.size(); ++i) {
                VarType from = GenericType.parse("T" + cl.getSignature().fparameters.get(i) + ";");
                VarType to = genType.getArguments().get(i);
                if (from == null || to == null) continue;
                genArgs.put(from, to);
            }
        }
        boolean firstParameter = true;
        for (int i = start = isEnum ? 2 : 0; i < this.lstParameters.size(); ++i) {
            VarType remappedType;
            if (sigFields != null && sigFields.get(i) != null) continue;
            if (!firstParameter) {
                buf.append(", ");
            }
            TextBuffer buff = new TextBuffer();
            boolean ambiguous = setAmbiguousParameters.get(i);
            VarType type = this.descriptor.params[i];
            if (desc != null && desc.getSignature() != null && desc.getSignature().params.size() == this.lstParameters.size()) {
                type = desc.getSignature().params.get(i);
            }
            if (type != (remappedType = type.remap(genArgs))) {
                type = remappedType;
            } else if (desc != null && desc.getSignature() != null && this.genericArgs.size() != 0) {
                HashMap<VarType, VarType> genMap = new HashMap<VarType, VarType>();
                for (int j = 0; j < this.genericArgs.size(); ++j) {
                    VarType from = GenericType.parse("T" + desc.getSignature().fparameters.get(j) + ";");
                    VarType to = this.genericArgs.get(j);
                    genMap.put(from, to);
                }
                type = type.remap(genMap);
            }
            VarType exprType = this.lstParameters.get(i).getInferredExprType(type);
            if (exprType != null && type != null && type.type == 18) {
                type = exprType;
            }
            ExprProcessor.getCastedExprent(this.lstParameters.get(i), type, buff, indent, type.type != 13, ambiguous, tracer);
            buf.append(buff);
            firstParameter = false;
        }
        buf.append(")");
        return buf;
    }

    private List<StructMethod> getMatchedDescriptors() {
        ArrayList<StructMethod> matches = new ArrayList<StructMethod>();
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null) {
            return matches;
        }
        block0: for (StructMethod mt : cl.getMethods()) {
            if (!this.name.equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length != this.descriptor.params.length) continue;
            for (int i = 0; i < md.params.length; ++i) {
                if (md.params[i].typeFamily != this.descriptor.params[i].typeFamily) continue block0;
            }
            matches.add(mt);
        }
        return matches;
    }

    private BitSet getAmbiguousParameters(List<StructMethod> matches) {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null) {
            return EMPTY_BIT_SET;
        }
        if (matches.size() == 1) {
            return EMPTY_BIT_SET;
        }
        StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
        if (mt != null) {
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length == this.lstParameters.size()) {
                boolean exact = true;
                for (int i = 0; i < md.params.length; ++i) {
                    if (md.params[i].equals(this.lstParameters.get(i).getExprType())) continue;
                    exact = false;
                    break;
                }
                if (exact) {
                    return EMPTY_BIT_SET;
                }
            }
        }
        BitSet ambiguous = new BitSet(this.descriptor.params.length);
        block1: for (int i = 0; i < this.descriptor.params.length; ++i) {
            VarType paramType = this.descriptor.params[i];
            for (StructMethod mtt : matches) {
                if (mtt.getSignature() != null && mtt.getSignature().params.get(i).isGeneric()) break;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
                if (paramType.equals(md.params[i])) continue;
                ambiguous.set(i);
                continue block1;
            }
        }
        return ambiguous;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            if (oldExpr != this.lstParameters.get(i)) continue;
            this.lstParameters.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return InterpreterUtil.equalObjects(this.name, it.getName()) && InterpreterUtil.equalObjects(this.classname, it.getClassname()) && this.isStatic == it.isStatic() && InterpreterUtil.equalObjects(this.instance, it.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, it.getDescriptor()) && this.functype == it.getFunctype() && InterpreterUtil.equalLists(this.lstParameters, it.getLstParameters());
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        InvocationExprent.measureBytecode(values, this.lstParameters);
        InvocationExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    public List<Exprent> getLstParameters() {
        return this.lstParameters;
    }

    public void setLstParameters(List<Exprent> lstParameters) {
        this.lstParameters = lstParameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public int getFunctype() {
        return this.functype;
    }

    public void setFunctype(int functype) {
        this.functype = functype;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public int getInvocationTyp() {
        return this.invocationTyp;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invokeDynamicClassSuffix;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            switch (rule.getKey()) {
                case EXPRENT_INVOCATION_PARAMETER: {
                    if (!value.isVariable()) break;
                    if (value.parameter < this.lstParameters.size()) {
                        if (engine.checkAndSetVariableValue(value.value.toString(), this.lstParameters.get(value.parameter))) break;
                        return false;
                    }
                    return false;
                }
                case EXPRENT_INVOCATION_CLASS: {
                    if (value.value.equals(this.classname)) break;
                    return false;
                }
                case EXPRENT_INVOCATION_SIGNATURE: {
                    if (value.value.equals(this.name + this.stringDescriptor)) break;
                    return false;
                }
            }
        }
        return true;
    }
}

