/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LVTVariable;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructEnclosingMethodAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class NestedClassProcessor {
    public void processClass(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode node) {
        ClassesProcessor.ClassNode node_content;
        if (node.type == 8 && !node.lambdaInformation.is_method_reference && (node_content = DecompilerContext.getClassProcessor().getMapRootClasses().get(node.classStruct.qualifiedName)) != null && node_content.getWrapper() != null) {
            node_content.getWrapper().getHiddenMembers().add(node.lambdaInformation.content_method_key);
        }
        if (node.nested.isEmpty()) {
            return;
        }
        if (DecompilerContext.getOption("den")) {
            this.gatherEnumSwitchMaps(node);
        }
        if (node.type != 8) {
            NestedClassProcessor.computeLocalVarsAndDefinitions(node);
            NestedClassProcessor.checkNotFoundClasses(root, node);
        }
        int nameless = 0;
        int synthetics = 0;
        for (ClassesProcessor.ClassNode child : node.nested) {
            if (child.type != 4 && child.type != 1 || child.simpleName != null) continue;
            StructClass cl = child.classStruct;
            if ((child.access & 0x1000) != 0 || cl.isSynthetic()) {
                child.simpleName = "SyntheticClass_" + ++synthetics;
            } else {
                String message = "Nameless local or member class " + cl.qualifiedName + "!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                child.simpleName = "NamelessClass_" + ++nameless;
            }
            child.namelessConstructorStub = !cl.hasModifier(8) && cl.getMethods().size() + cl.getFields().size() == 0;
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            if (child.type == 8) {
                NestedClassProcessor.setLambdaVars(node, child);
                continue;
            }
            if (child.type == 1 && (child.access & 8) != 0) continue;
            NestedClassProcessor.insertLocalVars(node, child);
            if (child.type != 4) continue;
            NestedClassProcessor.setLocalClassDefinition(node.getWrapper().getMethods().getWithKey(child.enclosingMethod), child);
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.processClass(root, child);
        }
    }

    private void gatherEnumSwitchMaps(ClassesProcessor.ClassNode node) {
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.gatherEnumSwitchMaps(child);
        }
        MethodWrapper clinit = node.getWrapper().getMethodWrapper("<clinit>", "()V");
        if (clinit == null || clinit.root == null || clinit.root.getFirst().type != 15) {
            return;
        }
        int STATIC_FINAL_SYNTHETIC = 4120;
        HashSet<String> potentialFields = new HashSet<String>();
        for (StructField fd : node.classStruct.getFields()) {
            if ((fd.getAccessFlags() & 0x1018) != 4120 || !"[I".equals(fd.getDescriptor())) continue;
            potentialFields.add(fd.getName());
        }
        if (potentialFields.size() == 0) {
            return;
        }
        SequenceStatement seq = (SequenceStatement)clinit.root.getFirst();
        int x = 0;
        while (x < seq.getStats().size()) {
            InvocationExprent invoc;
            FunctionExprent func;
            Statement stat = (Statement)seq.getStats().get(x);
            if (stat.type != 8 || stat.getExprents() == null || stat.getExprents().size() != 1 || stat.getExprents().get((int)0).type != 2) break;
            AssignmentExprent ass = (AssignmentExprent)stat.getExprents().get(0);
            if (ass.getLeft().type != 5 || ass.getRight().type != 10) break;
            FieldExprent mapField = (FieldExprent)ass.getLeft();
            NewExprent _new = (NewExprent)ass.getRight();
            if (!mapField.getClassname().equals(node.classStruct.qualifiedName) || !potentialFields.contains(mapField.getName()) || _new.getNewType().type != 4 || _new.getNewType().arrayDim != 1 || _new.getLstDims().size() != 1 || _new.getLstDims().get((int)0).type != 6 || (func = (FunctionExprent)_new.getLstDims().get(0)).getFuncType() != 31 || func.getLstOperands().size() != 1 || func.getLstOperands().get((int)0).type != 8 || !"values".equals((invoc = (InvocationExprent)func.getLstOperands().get(0)).getName()) || !("()[L" + invoc.getClassname() + ";").equals(invoc.getStringDescriptor())) break;
            String fieldName = mapField.getName();
            String enumName = invoc.getClassname();
            HashMap<Integer, String> idToName = new HashMap<Integer, String>();
            boolean replace = false;
            int y = x;
            while (++y < seq.getStats().size() && ((Statement)seq.getStats().get((int)y)).type == 7) {
                FieldExprent enumField;
                CatchStatement _try = (CatchStatement)seq.getStats().get(y);
                Statement first = _try.getFirst();
                List<Exprent> exprents = first.getExprents();
                if (_try.getVars().size() != 1 || !"java/lang/NoSuchFieldError".equals(_try.getVars().get((int)0).getVarType().value) || first.type != 8 || exprents == null || exprents.size() != 1 || exprents.get((int)0).type != 2) break;
                ass = (AssignmentExprent)exprents.get(0);
                if (ass.getRight().type != 3 || !(((ConstExprent)ass.getRight()).getValue() instanceof Integer) || ass.getLeft().type != 1) break;
                ArrayExprent array = (ArrayExprent)ass.getLeft();
                if (array.getArray().type != 5 || !array.getArray().equals(mapField) || array.getIndex().type != 8 || !enumName.equals((invoc = (InvocationExprent)array.getIndex()).getClassname()) || !"ordinal".equals(invoc.getName()) || !"()I".equals(invoc.getStringDescriptor()) || invoc.getInstance().type != 5 || !enumName.equals((enumField = (FieldExprent)invoc.getInstance()).getClassname()) || !enumField.isStatic()) break;
                idToName.put((Integer)((ConstExprent)ass.getRight()).getValue(), enumField.getName());
                seq.replaceStatement(_try, this.getNewEmptyStatement());
                replace = true;
            }
            if (replace) {
                seq.replaceStatement((Statement)seq.getStats().get(x), this.getNewEmptyStatement());
                node.classStruct.enumSwitchMap.put(fieldName, idToName);
                node.getWrapper().getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fieldName, "[I"));
            }
            x = y;
        }
    }

    private Statement getNewEmptyStatement() {
        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        bstat.setExprents(new ArrayList<Exprent>());
        return bstat;
    }

    private static void setLambdaVars(ClassesProcessor.ClassNode parent, ClassesProcessor.ClassNode child) {
        if (child.lambdaInformation.is_method_reference) {
            return;
        }
        MethodWrapper meth = parent.getWrapper().getMethods().getWithKey(child.lambdaInformation.content_method_key);
        final MethodWrapper encmeth = parent.getWrapper().getMethods().getWithKey(child.enclosingMethod);
        MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(child.lambdaInformation.method_descriptor);
        final MethodDescriptor md_content = MethodDescriptor.parseDescriptor(child.lambdaInformation.content_method_descriptor);
        final int vars_count = md_content.params.length - md_lambda.params.length;
        final boolean is_static_lambda_content = child.lambdaInformation.is_content_method_static;
        String parent_class_name = parent.getWrapper().getClassStruct().qualifiedName;
        String lambda_class_name = child.simpleName;
        final VarType lambda_class_type = new VarType(lambda_class_name, true);
        if (!is_static_lambda_content && DecompilerContext.getOption("lac")) {
            meth.varproc.getThisVars().put(new VarVersionPair(0, 0), parent_class_name);
            meth.varproc.setVarName(new VarVersionPair(0, 0), parent.simpleName + ".this");
        }
        DirectGraph graph = encmeth.getOrBuildGraph();
        final HashMap mapNewNames = new HashMap();
        graph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    NewExprent new_expr;
                    if (expr.type != 10 || !(new_expr = (NewExprent)expr).isLambda() || !lambda_class_type.equals(new_expr.getNewType())) continue;
                    InvocationExprent inv_dynamic = new_expr.getConstructor();
                    int param_index = is_static_lambda_content ? 0 : 1;
                    int varindex = is_static_lambda_content ? 0 : 1;
                    for (int i = 0; i < vars_count; ++i) {
                        Exprent param = inv_dynamic.getLstParameters().get(param_index + i);
                        if (param.type == 12) {
                            VarVersionPair enc_varpaar = new VarVersionPair((VarExprent)param);
                            String enc_varname = encmeth.varproc.getVarName(enc_varpaar);
                            mapNewNames.put(new VarVersionPair(varindex, 0), enc_varname);
                        }
                        varindex += md_content.params[i].stackSize;
                    }
                }
                return 0;
            }
        });
        HashSet<String> setNewOuterNames = new HashSet<String>(mapNewNames.values());
        setNewOuterNames.removeAll(meth.setOuterVarNames);
        meth.varproc.refreshVarNames(new VarNamesCollector(setNewOuterNames));
        meth.setOuterVarNames.addAll(setNewOuterNames);
        for (Map.Entry entr : mapNewNames.entrySet()) {
            meth.varproc.setVarName((VarVersionPair)entr.getKey(), (String)entr.getValue());
        }
    }

    private static void checkNotFoundClasses(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode node) {
        ArrayList<ClassesProcessor.ClassNode> lstChildren = new ArrayList<ClassesProcessor.ClassNode>(node.nested);
        for (ClassesProcessor.ClassNode child : lstChildren) {
            String message;
            boolean hasEnclosing;
            StructEnclosingMethodAttribute attr;
            if (child.type != 4 && child.type != 2 || child.enclosingMethod != null) continue;
            Set<String> setEnclosing = child.enclosingClasses;
            if (setEnclosing.size() == 1 && (attr = (StructEnclosingMethodAttribute)child.classStruct.getAttributes().getWithKey("EnclosingMethod")) != null && attr.getMethodName() != null && node.classStruct.qualifiedName.equals(attr.getClassName()) && node.classStruct.getMethod(attr.getMethodName(), attr.getMethodDescriptor()) != null) {
                child.enclosingMethod = InterpreterUtil.makeUniqueKey(attr.getMethodName(), attr.getMethodDescriptor());
                continue;
            }
            node.nested.remove(child);
            child.parent = null;
            setEnclosing.remove(node.classStruct.qualifiedName);
            boolean bl = hasEnclosing = !setEnclosing.isEmpty();
            if (hasEnclosing) {
                hasEnclosing = NestedClassProcessor.insertNestedClass(root, child);
            }
            if (hasEnclosing) continue;
            if (child.type == 2) {
                if (child.classStruct.hasModifier(4096)) continue;
                message = "Unreferenced anonymous class " + child.classStruct.qualifiedName + "!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                continue;
            }
            if (child.type != 4) continue;
            message = "Unreferenced local class " + child.classStruct.qualifiedName + "!";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
    }

    private static boolean insertNestedClass(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode child) {
        Set<String> setEnclosing = child.enclosingClasses;
        LinkedList<ClassesProcessor.ClassNode> stack = new LinkedList<ClassesProcessor.ClassNode>();
        stack.add(root);
        while (!stack.isEmpty()) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)stack.removeFirst();
            if (setEnclosing.contains(node.classStruct.qualifiedName)) {
                node.nested.add(child);
                child.parent = node;
                Collections.sort(node.nested);
                return true;
            }
            stack.addAll(node.nested);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void computeLocalVarsAndDefinitions(final ClassesProcessor.ClassNode node) {
        final HashMap<String, HashMap<String, List<VarFieldPair>>> mapVarMasks = new HashMap<String, HashMap<String, List<VarFieldPair>>>();
        int cltypes = 0;
        for (ClassesProcessor.ClassNode nd : node.nested) {
            if (nd.type == 8 || (nd.access & 8) != 0 || (nd.access & 0x200) != 0) continue;
            cltypes |= nd.type;
            HashMap<String, List<VarFieldPair>> mask = NestedClassProcessor.getMaskLocalVars(nd.getWrapper());
            if (mask.isEmpty()) {
                if (nd.classStruct.hasModifier(4096)) continue;
                String message = "Nested class " + nd.classStruct.qualifiedName + " has no constructor!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                continue;
            }
            mapVarMasks.put(nd.classStruct.qualifiedName, mask);
        }
        final HashMap mapVarFieldPairs = new HashMap();
        if (cltypes != 1) {
            for (final MethodWrapper meth : node.getWrapper().getMethods()) {
                if (meth.root == null) continue;
                DirectGraph graph = meth.getOrBuildGraph();
                DotExporter.toDotFile(graph, meth.methodStruct, "computeLocalVars");
                graph.iterateExprents(new DirectGraph.ExprentIterator(){

                    @Override
                    public int processExprent(Exprent exprent) {
                        List<Exprent> lst = exprent.getAllExprents(true);
                        lst.add(exprent);
                        for (Exprent expr : lst) {
                            InvocationExprent constr;
                            if (expr.type != 10 || (constr = ((NewExprent)expr).getConstructor()) == null || !mapVarMasks.containsKey(constr.getClassname())) continue;
                            String refclname = constr.getClassname();
                            ClassesProcessor.ClassNode nestedClassNode = node.getClassNode(refclname);
                            if (nestedClassNode.type == 1) continue;
                            List mask = (List)((HashMap)mapVarMasks.get(refclname)).get(constr.getStringDescriptor());
                            if (!mapVarFieldPairs.containsKey(refclname)) {
                                mapVarFieldPairs.put(refclname, new HashMap());
                            }
                            ArrayList<VarFieldPair> lstTemp = new ArrayList<VarFieldPair>();
                            for (int i = 0; i < mask.size(); ++i) {
                                Exprent param = constr.getLstParameters().get(i);
                                VarFieldPair pair = null;
                                if (param.type == 12 && mask.get(i) != null) {
                                    VarVersionPair varpaar = new VarVersionPair((VarExprent)param);
                                    pair = new VarFieldPair(((VarFieldPair)mask.get((int)i)).keyfield, varpaar);
                                }
                                lstTemp.add(pair);
                            }
                            ArrayList<VarFieldPair> pairmask = (ArrayList<VarFieldPair>)((HashMap)mapVarFieldPairs.get(refclname)).get(constr.getStringDescriptor());
                            if (pairmask == null) {
                                pairmask = lstTemp;
                            } else {
                                for (int i = 0; i < pairmask.size(); ++i) {
                                    if (InterpreterUtil.equalObjects(pairmask.get(i), lstTemp.get(i))) continue;
                                    pairmask.set(i, null);
                                }
                            }
                            ((HashMap)mapVarFieldPairs.get(refclname)).put(constr.getStringDescriptor(), pairmask);
                            nestedClassNode.enclosingMethod = InterpreterUtil.makeUniqueKey(meth.methodStruct.getName(), meth.methodStruct.getDescriptor());
                        }
                        return 0;
                    }
                });
            }
        }
        for (Map.Entry entcl : mapVarMasks.entrySet()) {
            ClassesProcessor.ClassNode nestedNode = node.getClassNode((String)entcl.getKey());
            ArrayList<VarFieldPair> intrPairMask = null;
            if (mapVarFieldPairs.containsKey(entcl.getKey())) {
                for (List mask : ((HashMap)mapVarFieldPairs.get(entcl.getKey())).values()) {
                    if (intrPairMask == null) {
                        intrPairMask = new ArrayList(mask);
                        continue;
                    }
                    NestedClassProcessor.mergeListSignatures(intrPairMask, mask, false);
                }
            }
            ArrayList intrMask = null;
            for (List list : ((HashMap)entcl.getValue()).values()) {
                if (intrMask == null) {
                    intrMask = new ArrayList(list);
                    continue;
                }
                NestedClassProcessor.mergeListSignatures(intrMask, list, false);
            }
            if (intrPairMask == null) {
                void var10_15;
                intrPairMask = new ArrayList<VarFieldPair>(intrMask);
                boolean found = false;
                boolean bl = false;
                while (var10_15 < intrPairMask.size()) {
                    if (intrPairMask.get((int)var10_15) != null) {
                        if (found) {
                            intrPairMask.set((int)var10_15, null);
                        }
                        found = true;
                    }
                    ++var10_15;
                }
            }
            NestedClassProcessor.mergeListSignatures(intrPairMask, intrMask, true);
            for (int i = 0; i < intrPairMask.size(); ++i) {
                VarFieldPair varFieldPair = (VarFieldPair)intrPairMask.get(i);
                if (varFieldPair == null || varFieldPair.keyfield.length() <= 0) continue;
                nestedNode.mapFieldsToVars.put(varFieldPair.keyfield, varFieldPair.varpaar);
            }
            for (Map.Entry entry : ((HashMap)entcl.getValue()).entrySet()) {
                NestedClassProcessor.mergeListSignatures((List)entry.getValue(), intrPairMask, false);
                MethodWrapper meth = nestedNode.getWrapper().getMethodWrapper("<init>", (String)entry.getKey());
                meth.signatureFields = new ArrayList<VarVersionPair>();
                for (VarFieldPair pair : (List)entry.getValue()) {
                    meth.signatureFields.add(pair == null ? null : pair.varpaar);
                }
            }
        }
    }

    private static void insertLocalVars(ClassesProcessor.ClassNode parent, final ClassesProcessor.ClassNode child) {
        MethodWrapper encmeth = parent.getWrapper().getMethods().getWithKey(child.enclosingMethod);
        for (final MethodWrapper meth : child.getWrapper().getMethods()) {
            if (meth.root == null) continue;
            if (encmeth != null) {
                meth.methodStruct.renamer.addParentContext(encmeth.methodStruct.renamer);
            }
            HashMap<VarVersionPair, String> mapNewNames = new HashMap<VarVersionPair, String>();
            HashMap<VarVersionPair, VarType> mapNewTypes = new HashMap<VarVersionPair, VarType>();
            HashMap<VarVersionPair, LVTVariable> mapNewLVTs = new HashMap<VarVersionPair, LVTVariable>();
            final HashMap<Integer, VarVersionPair> mapParamsToNewVars = new HashMap<Integer, VarVersionPair>();
            if (meth.signatureFields != null) {
                int index = 0;
                int varindex = 1;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(meth.methodStruct.getDescriptor());
                for (VarVersionPair paar : meth.signatureFields) {
                    if (paar != null) {
                        VarVersionPair newvar = new VarVersionPair(meth.counter.getCounterAndIncrement(2), 0);
                        mapParamsToNewVars.put(varindex, newvar);
                        String varname = null;
                        VarType vartype = null;
                        LVTVariable varlvt = null;
                        if (child.type != 1) {
                            varname = encmeth.varproc.getVarName(paar);
                            vartype = encmeth.varproc.getVarType(paar);
                            varlvt = encmeth.varproc.getVarLVT(paar);
                            encmeth.varproc.setVarFinal(paar, 2);
                        }
                        if (paar.var == -1 || "this".equals(varname) || varlvt != null && "this".equals(varlvt.name)) {
                            varname = parent.simpleName == null ? "<VAR_NAMELESS_ENCLOSURE>" : parent.simpleName + ".this";
                            if (varlvt != null) {
                                varlvt = varlvt.rename(varname);
                            }
                            meth.varproc.getThisVars().put(newvar, parent.classStruct.qualifiedName);
                        }
                        mapNewNames.put(newvar, varname);
                        mapNewTypes.put(newvar, vartype);
                        mapNewLVTs.put(newvar, varlvt);
                    }
                    varindex += md.params[index++].stackSize;
                }
            }
            final HashMap<String, VarVersionPair> mapFieldsToNewVars = new HashMap<String, VarVersionPair>();
            ClassesProcessor.ClassNode clnode = child;
            while (clnode != null) {
                for (Map.Entry<String, VarVersionPair> entry : clnode.mapFieldsToVars.entrySet()) {
                    VarVersionPair newvar = new VarVersionPair(meth.counter.getCounterAndIncrement(2), 0);
                    mapFieldsToNewVars.put(InterpreterUtil.makeUniqueKey(clnode.classStruct.qualifiedName, entry.getKey()), newvar);
                    String varname = null;
                    VarType vartype = null;
                    LVTVariable varlvt = null;
                    if (clnode.type != 1) {
                        MethodWrapper enclosing_method = clnode.parent.getWrapper().getMethods().getWithKey(clnode.enclosingMethod);
                        varname = enclosing_method.varproc.getVarName(entry.getValue());
                        vartype = enclosing_method.varproc.getVarType(entry.getValue());
                        varlvt = enclosing_method.varproc.getVarLVT(entry.getValue());
                        enclosing_method.varproc.setVarFinal(entry.getValue(), 2);
                    }
                    if (entry.getValue().var == -1 || "this".equals(varname) || varlvt != null && "this".equals(varlvt.name)) {
                        varname = clnode.parent.simpleName == null ? "<VAR_NAMELESS_ENCLOSURE>" : clnode.parent.simpleName + ".this";
                        if (varlvt != null) {
                            varlvt = varlvt.rename(varname);
                        }
                        meth.varproc.getThisVars().put(newvar, clnode.parent.classStruct.qualifiedName);
                    }
                    mapNewNames.put(newvar, varname);
                    mapNewTypes.put(newvar, vartype);
                    mapNewLVTs.put(newvar, varlvt);
                    if (clnode != child) continue;
                    StructField fd = child.classStruct.getFields().getWithKey(entry.getKey());
                    child.getWrapper().getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                }
                clnode = clnode.parent;
            }
            HashSet<String> setNewOuterNames = new HashSet<String>(mapNewNames.values());
            setNewOuterNames.removeAll(meth.setOuterVarNames);
            meth.varproc.refreshVarNames(new VarNamesCollector(setNewOuterNames));
            meth.setOuterVarNames.addAll(setNewOuterNames);
            for (Map.Entry<String, VarVersionPair> entry : mapNewNames.entrySet()) {
                VarVersionPair varpaar = (VarVersionPair)((Object)entry.getKey());
                VarType vartype = (VarType)mapNewTypes.get(varpaar);
                LVTVariable varlvt = (LVTVariable)mapNewLVTs.get(varpaar);
                meth.varproc.setVarName(varpaar, (String)((Object)entry.getValue()));
                if (vartype != null) {
                    meth.varproc.setVarType(varpaar, vartype);
                }
                if (varlvt == null) continue;
                meth.varproc.setVarLVT(varpaar, varlvt);
            }
            DirectGraph graph = meth.getOrBuildGraph();
            NestedClassProcessor.iterateExprents(graph, new ExprentIteratorWithReplace(){

                @Override
                public Exprent processExprent(Exprent exprent) {
                    InvocationExprent invexpr;
                    if (exprent.type == 2) {
                        FieldExprent fexpr;
                        AssignmentExprent asexpr = (AssignmentExprent)exprent;
                        if (asexpr.getLeft().type == 5 && (fexpr = (FieldExprent)asexpr.getLeft()).getClassname().equals(child.classStruct.qualifiedName) && mapFieldsToNewVars.containsKey(InterpreterUtil.makeUniqueKey(child.classStruct.qualifiedName, InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString)))) {
                            return null;
                        }
                    }
                    if (child.type == 2 && "<init>".equals(meth.methodStruct.getName()) && exprent.type == 8 && (invexpr = (InvocationExprent)exprent).getFunctype() == 2) {
                        child.superInvocation = invexpr;
                        return null;
                    }
                    Exprent ret = this.replaceExprent(exprent);
                    return ret == null ? exprent : ret;
                }

                private Exprent replaceExprent(Exprent exprent) {
                    FieldExprent fexpr;
                    String keyField;
                    if (exprent.type == 12) {
                        int varindex = ((VarExprent)exprent).getIndex();
                        if (mapParamsToNewVars.containsKey(varindex)) {
                            VarVersionPair newvar = (VarVersionPair)mapParamsToNewVars.get(varindex);
                            meth.varproc.getExternalVars().add(newvar);
                            VarExprent ret = new VarExprent(newvar.var, meth.varproc.getVarType(newvar), meth.varproc);
                            LVTVariable lvt = meth.varproc.getVarLVT(newvar);
                            if (lvt != null) {
                                ret.setLVT(lvt);
                            }
                            return ret;
                        }
                    } else if (exprent.type == 5 && mapFieldsToNewVars.containsKey(keyField = InterpreterUtil.makeUniqueKey((fexpr = (FieldExprent)exprent).getClassname(), InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString)))) {
                        VarVersionPair newvar = (VarVersionPair)mapFieldsToNewVars.get(keyField);
                        meth.varproc.getExternalVars().add(newvar);
                        VarExprent ret = new VarExprent(newvar.var, meth.varproc.getVarType(newvar), meth.varproc);
                        LVTVariable lvt = meth.varproc.getVarLVT(newvar);
                        if (lvt != null) {
                            ret.setLVT(lvt);
                        }
                        return ret;
                    }
                    boolean replaced = true;
                    block0: while (replaced) {
                        replaced = false;
                        for (Exprent expr : exprent.getAllExprents()) {
                            Exprent retexpr = this.replaceExprent(expr);
                            if (retexpr == null) continue;
                            exprent.replaceExprent(expr, retexpr);
                            replaced = true;
                            continue block0;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private static HashMap<String, List<VarFieldPair>> getMaskLocalVars(ClassWrapper wrapper) {
        HashMap<String, List<VarFieldPair>> mapMasks = new HashMap<String, List<VarFieldPair>>();
        StructClass cl = wrapper.getClassStruct();
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            MethodWrapper meth = wrapper.getMethodWrapper("<init>", mt.getDescriptor());
            DirectGraph graph = meth.getOrBuildGraph();
            if (graph == null) continue;
            ArrayList<VarFieldPair> fields = new ArrayList<VarFieldPair>();
            int varindex = 1;
            for (int i = 0; i < md.params.length; ++i) {
                String keyField = NestedClassProcessor.getEnclosingVarField(cl, meth, graph, varindex);
                fields.add(keyField == null ? null : new VarFieldPair(keyField, new VarVersionPair(-1, 0)));
                varindex += md.params[i].stackSize;
            }
            mapMasks.put(mt.getDescriptor(), fields);
        }
        return mapMasks;
    }

    private static String getEnclosingVarField(StructClass cl, MethodWrapper meth, DirectGraph graph, int index) {
        String field = "";
        if (meth.varproc.getVarFinal(new VarVersionPair(index, 0)) == 1) {
            return null;
        }
        boolean noSynthFlag = DecompilerContext.getOption("nns");
        DirectNode firstnode = graph.first;
        if (firstnode.preds.isEmpty()) {
            for (Exprent exprent : firstnode.exprents) {
                FieldExprent left;
                StructField fd;
                if (exprent.type != 2) continue;
                AssignmentExprent asexpr = (AssignmentExprent)exprent;
                if (asexpr.getRight().type != 12 || ((VarExprent)asexpr.getRight()).getIndex() != index || asexpr.getLeft().type != 5 || (fd = cl.getField((left = (FieldExprent)asexpr.getLeft()).getName(), left.getDescriptor().descriptorString)) == null || !cl.qualifiedName.equals(left.getClassname()) || !fd.hasModifier(16) || !fd.isSynthetic() && (!noSynthFlag || !fd.hasModifier(2))) continue;
                field = InterpreterUtil.makeUniqueKey(left.getName(), left.getDescriptor().descriptorString);
                break;
            }
        }
        return field;
    }

    private static void mergeListSignatures(List<VarFieldPair> first, List<VarFieldPair> second, boolean both) {
        int j;
        boolean eq;
        VarFieldPair sobj;
        int i;
        for (i = 1; first.size() > i && second.size() > i; ++i) {
            VarFieldPair fobj = first.get(first.size() - i);
            sobj = second.get(second.size() - i);
            eq = false;
            if (fobj == null || sobj == null) {
                eq = fobj == sobj;
            } else {
                eq = true;
                if (fobj.keyfield.length() == 0) {
                    fobj.keyfield = sobj.keyfield;
                } else if (sobj.keyfield.length() == 0) {
                    if (both) {
                        sobj.keyfield = fobj.keyfield;
                    }
                } else {
                    eq = fobj.keyfield.equals(sobj.keyfield);
                }
            }
            if (!eq) {
                first.set(first.size() - i, null);
                if (!both) continue;
                second.set(second.size() - i, null);
                continue;
            }
            if (fobj == null) continue;
            if (fobj.varpaar.var == -1) {
                fobj.varpaar = sobj.varpaar;
                continue;
            }
            sobj.varpaar = fobj.varpaar;
        }
        for (j = 1; j <= first.size() - i; ++j) {
            first.set(j, null);
        }
        if (both) {
            for (j = 1; j <= second.size() - i; ++j) {
                second.set(j, null);
            }
        }
        if (first.isEmpty()) {
            if (!second.isEmpty() && both) {
                second.set(0, null);
            }
        } else if (second.isEmpty()) {
            first.set(0, null);
        } else {
            VarFieldPair fobj = first.get(0);
            sobj = second.get(0);
            eq = false;
            if (fobj == null || sobj == null) {
                eq = fobj == sobj;
            } else {
                eq = true;
                if (fobj.keyfield.length() == 0) {
                    fobj.keyfield = sobj.keyfield;
                } else if (sobj.keyfield.length() == 0) {
                    if (both) {
                        sobj.keyfield = fobj.keyfield;
                    }
                } else {
                    eq = fobj.keyfield.equals(sobj.keyfield);
                }
            }
            if (!eq) {
                first.set(0, null);
                if (both) {
                    second.set(0, null);
                }
            } else if (fobj != null) {
                if (fobj.varpaar.var == -1) {
                    fobj.varpaar = sobj.varpaar;
                } else {
                    sobj.varpaar = fobj.varpaar;
                }
            }
        }
    }

    private static void setLocalClassDefinition(MethodWrapper meth, ClassesProcessor.ClassNode node) {
        Statement first;
        RootStatement root = meth.root;
        VarType classtype = new VarType(node.classStruct.qualifiedName, true);
        HashSet<Statement> setStats = new HashSet<Statement>();
        Statement stdef = NestedClassProcessor.getDefStatement(root, classtype, setStats);
        if (stdef == null) {
            stdef = root.getFirst();
        }
        List<Exprent> lst = (first = NestedClassProcessor.findFirstBlock(stdef, setStats)) == null ? stdef.getVarDefinitions() : (first.getExprents() == null ? first.getVarDefinitions() : first.getExprents());
        int addindex = 0;
        for (Exprent expr : lst) {
            if (NestedClassProcessor.searchForClass(expr, classtype)) break;
            ++addindex;
        }
        VarExprent var = new VarExprent(meth.counter.getCounterAndIncrement(2), classtype, meth.varproc);
        var.setDefinition(true);
        var.setClassDef(true);
        lst.add(addindex, var);
    }

    private static Statement findFirstBlock(Statement stat, HashSet<Statement> setStats) {
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(stat);
        block4: while (!stack.isEmpty()) {
            Statement st = (Statement)stack.remove(0);
            if (!stack.isEmpty() && !setStats.contains(st)) continue;
            if (st.isLabeled() && !stack.isEmpty()) {
                return st;
            }
            if (st.getExprents() != null) {
                return st;
            }
            stack.clear();
            switch (st.type) {
                case 15: {
                    stack.addAll(0, st.getStats());
                    continue block4;
                }
                case 2: 
                case 6: 
                case 10: 
                case 13: {
                    stack.add(st.getFirst());
                    continue block4;
                }
            }
            return st;
        }
        return null;
    }

    private static Statement getDefStatement(Statement stat, VarType classtype, HashSet<Statement> setStats) {
        List<Object> condlst = new ArrayList();
        Statement retstat = null;
        if (stat.getExprents() == null) {
            int counter = 0;
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    Statement st = (Statement)obj;
                    Statement stTemp = NestedClassProcessor.getDefStatement(st, classtype, setStats);
                    if (stTemp != null) {
                        if (counter == 1) {
                            retstat = stat;
                            break;
                        }
                        retstat = stTemp;
                        ++counter;
                    }
                    if (st.type != 5) continue;
                    DoStatement dost = (DoStatement)st;
                    condlst.addAll(dost.getInitExprentList());
                    condlst.addAll(dost.getConditionExprentList());
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                condlst.add((Exprent)obj);
            }
        } else {
            condlst = stat.getExprents();
        }
        if (retstat != stat) {
            for (Exprent exprent : condlst) {
                if (exprent == null || !NestedClassProcessor.searchForClass(exprent, classtype)) continue;
                retstat = stat;
                break;
            }
        }
        if (retstat != null) {
            setStats.add(stat);
        }
        return retstat;
    }

    private static boolean searchForClass(Exprent exprent, VarType classtype) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        String classname = classtype.value;
        for (Exprent expr : lst) {
            boolean res = false;
            switch (expr.type) {
                case 3: {
                    ConstExprent cexpr = (ConstExprent)expr;
                    res = VarType.VARTYPE_CLASS.equals(cexpr.getConstType()) && classname.equals(cexpr.getValue()) || classtype.equals(cexpr.getConstType());
                    break;
                }
                case 5: {
                    res = classname.equals(((FieldExprent)expr).getClassname());
                    break;
                }
                case 8: {
                    res = classname.equals(((InvocationExprent)expr).getClassname());
                    break;
                }
                case 10: {
                    VarType newType = ((NewExprent)expr).getNewType();
                    res = newType.type == 8 && classname.equals(newType.value);
                    break;
                }
                case 12: {
                    VarType vtype;
                    VarExprent vexpr = (VarExprent)expr;
                    if (!vexpr.isDefinition() || !classtype.equals(vtype = vexpr.getVarType()) && (vtype.arrayDim <= 0 || !classtype.value.equals(vtype.value))) break;
                    res = true;
                }
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    private static void iterateExprents(DirectGraph graph, ExprentIteratorWithReplace iter) {
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(graph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            for (int i = 0; i < node.exprents.size(); ++i) {
                Exprent res = iter.processExprent(node.exprents.get(i));
                if (res == null) {
                    node.exprents.remove(i);
                    --i;
                    continue;
                }
                if (res == node.exprents.get(i)) continue;
                node.exprents.set(i, res);
            }
            stack.addAll(node.succs);
        }
    }

    private static interface ExprentIteratorWithReplace {
        public Exprent processExprent(Exprent var1);
    }

    private static class VarFieldPair {
        public String keyfield = "";
        public VarVersionPair varpaar;

        public VarFieldPair(String field, VarVersionPair varpaar) {
            this.keyfield = field;
            this.varpaar = varpaar;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof VarFieldPair)) {
                return false;
            }
            VarFieldPair pair = (VarFieldPair)o;
            return this.keyfield.equals(pair.keyfield) && this.varpaar.equals(pair.varpaar);
        }

        public int hashCode() {
            return this.keyfield.hashCode() + this.varpaar.hashCode();
        }
    }
}

