/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.modules.renamer.IdentifierConverter;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;

public class Fernflower
implements IDecompiledData {
    private final StructContext structContext;
    private ClassesProcessor classesProcessor;

    public Fernflower(IBytecodeProvider provider, IResultSaver saver, Map<String, Object> options, IFernflowerLogger logger) {
        this.structContext = new StructContext(saver, this, new LazyLoader(provider));
        DecompilerContext.initContext(options);
        DecompilerContext.setCounterContainer(new CounterContainer());
        DecompilerContext.setLogger(logger);
        if (DecompilerContext.getOption("iec")) {
            this.addAllClasspath();
        }
    }

    public void decompileContext() {
        if (DecompilerContext.getOption("ren")) {
            new IdentifierConverter().rename(this.structContext);
        }
        this.classesProcessor = new ClassesProcessor(this.structContext);
        DecompilerContext.setClassProcessor(this.classesProcessor);
        DecompilerContext.setStructContext(this.structContext);
        this.structContext.saveContext();
    }

    public void clearContext() {
        DecompilerContext.setCurrentContext(null);
    }

    public StructContext getStructContext() {
        return this.structContext;
    }

    @Override
    public String getClassEntryName(StructClass cl, String entryName) {
        ClassesProcessor.ClassNode node = this.classesProcessor.getMapRootClasses().get(cl.qualifiedName);
        if (node.type != 0) {
            return null;
        }
        if (DecompilerContext.getOption("ren")) {
            String simple_classname = cl.qualifiedName.substring(cl.qualifiedName.lastIndexOf(47) + 1);
            return entryName.substring(0, entryName.lastIndexOf(47) + 1) + simple_classname + ".java";
        }
        return entryName.substring(0, entryName.lastIndexOf(".class")) + ".java";
    }

    @Override
    public String getClassContent(StructClass cl) {
        try {
            TextBuffer buffer = new TextBuffer(16384);
            buffer.append(DecompilerContext.getProperty("ban").toString());
            this.classesProcessor.writeClass(cl, buffer);
            return buffer.toString();
        }
        catch (Throwable ex) {
            DecompilerContext.getLogger().writeMessage("Class " + cl.qualifiedName + " couldn't be fully decompiled.", ex);
            return null;
        }
    }

    private void addAllClasspath() {
        String[] props;
        HashSet<String> found = new HashSet<String>();
        for (String prop : props = new String[]{System.getProperty("java.class.path"), System.getProperty("sun.boot.class.path")}) {
            if (prop == null) continue;
            for (String path : prop.split(File.pathSeparator)) {
                File file = new File(path);
                if (found.contains(file.getAbsolutePath()) || !file.exists() || !file.getName().endsWith(".class") && !file.getName().endsWith(".jar")) continue;
                DecompilerContext.getLogger().writeMessage("Adding File to context from classpath: " + file, IFernflowerLogger.Severity.INFO);
                this.structContext.addSpace(file, false);
                found.add(file.getAbsolutePath());
            }
        }
    }
}

