/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.util.Optional;
import net.minecraftforge.eventbus.Logging;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventSubscriptionTransformer {
    public Optional<ClassNode> transform(ClassNode classNode, Type classType) {
        try {
            if (!this.buildEvents(classNode)) {
                return Optional.empty();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            LogManager.getLogger((String)"EVENTBUS").error(Logging.EVENTBUS, "An error occurred building event handler", (Throwable)e);
        }
        return Optional.of(classNode);
    }

    private boolean buildEvents(ClassNode classNode) throws Exception {
        MethodNode method2;
        Class<?> parent = this.getClass().getClassLoader().loadClass(classNode.superName.replace('/', '.'));
        if (!Event.class.isAssignableFrom(parent)) {
            return false;
        }
        Type tList = Type.getType((String)"Lnet/minecraftforge/eventbus/ListenerList;");
        boolean hasSetup = false;
        boolean hasGetListenerList = false;
        boolean hasDefaultCtr = false;
        boolean hasCancelable = false;
        boolean hasResult = false;
        String voidDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        String boolDesc = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
        String listDesc = tList.getDescriptor();
        String listDescM = Type.getMethodDescriptor((Type)tList, (Type[])new Type[0]);
        for (MethodNode method2 : classNode.methods) {
            if (method2.name.equals("setup") && method2.desc.equals(voidDesc) && (method2.access & 4) == 4) {
                hasSetup = true;
            }
            if ((method2.access & 1) == 1) {
                if (method2.name.equals("getListenerList") && method2.desc.equals(listDescM)) {
                    hasGetListenerList = true;
                }
                if (method2.name.equals("isCancelable") && method2.desc.equals(boolDesc)) {
                    hasCancelable = true;
                }
                if (method2.name.equals("hasResult") && method2.desc.equals(boolDesc)) {
                    hasResult = true;
                }
            }
            if (!method2.name.equals("<init>") || !method2.desc.equals(voidDesc)) continue;
            hasDefaultCtr = true;
        }
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode node : classNode.visibleAnnotations) {
                MethodNode method3;
                if (!hasResult && node.desc.equals("Lnet/minecraftforge/eventbus/api/Event$HasResult;")) {
                    method3 = new MethodNode(1, "hasResult", boolDesc, null, null);
                    method3.instructions.add((AbstractInsnNode)new InsnNode(4));
                    method3.instructions.add((AbstractInsnNode)new InsnNode(172));
                    classNode.methods.add(method3);
                    continue;
                }
                if (hasCancelable || !node.desc.equals("Lnet/minecraftforge/eventbus/api/Cancelable;")) continue;
                method3 = new MethodNode(1, "isCancelable", boolDesc, null, null);
                method3.instructions.add((AbstractInsnNode)new InsnNode(4));
                method3.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method3);
            }
        }
        if (hasSetup) {
            if (!hasGetListenerList) {
                throw new RuntimeException("Event class defines setup() but does not define getListenerList! " + classNode.name);
            }
            return true;
        }
        Type tSuper = Type.getObjectType((String)classNode.superName);
        classNode.fields.add(new FieldNode(10, "LISTENER_LIST", listDesc, null, null));
        if (!hasDefaultCtr) {
            method2 = new MethodNode(1, "<init>", voidDesc, null, null);
            method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "<init>", voidDesc, false));
            method2.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method2);
        }
        method2 = new MethodNode(4, "setup", voidDesc, null, null);
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "setup", voidDesc, false));
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", listDesc));
        LabelNode initListener = new LabelNode();
        method2.instructions.add((AbstractInsnNode)new JumpInsnNode(198, initListener));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        method2.instructions.add((AbstractInsnNode)initListener);
        method2.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method2.instructions.add((AbstractInsnNode)new TypeInsnNode(187, tList.getInternalName()));
        method2.instructions.add((AbstractInsnNode)new InsnNode(89));
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "getListenerList", listDescM, false));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tList.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{tList}), false));
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(179, classNode.name, "LISTENER_LIST", listDesc));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(method2);
        method2 = new MethodNode(1, "getListenerList", listDescM, null, null);
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", listDesc));
        method2.instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method2);
        return true;
    }
}

