/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.Logging;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventExceptionHandler;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;

public class EventBus
implements IEventExceptionHandler,
IEventBus {
    private static int maxID = 0;
    private ConcurrentHashMap<Object, ArrayList<IEventListener>> listeners = new ConcurrentHashMap();
    private final int busID = maxID++;
    private final IEventExceptionHandler exceptionHandler;

    public EventBus() {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = this;
    }

    public EventBus(@Nonnull IEventExceptionHandler handler) {
        Objects.requireNonNull(handler, "EventBus exception handler can not be null");
        this.exceptionHandler = handler;
    }

    private void registerClass(Class<?> clazz) {
        Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.isAnnotationPresent(SubscribeEvent.class)).forEach(m -> this.registerListener(clazz, (Method)m, (Method)m));
    }

    private Optional<Method> getDeclMethod(Class<?> clz, Method in) {
        try {
            return Optional.of(clz.getDeclaredMethod(in.getName(), in.getParameterTypes()));
        }
        catch (NoSuchMethodException nse) {
            return Optional.empty();
        }
    }

    private void registerObject(Object obj) {
        HashSet classes = new HashSet();
        this.typesFor(obj.getClass(), classes);
        Arrays.stream(obj.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).forEach(m -> classes.stream().map(c -> this.getDeclMethod((Class<?>)c, (Method)m)).filter(rm -> rm.isPresent() && ((Method)rm.get()).isAnnotationPresent(SubscribeEvent.class)).findFirst().ifPresent(rm -> this.registerListener(obj, (Method)m, (Method)rm.get())));
    }

    private void typesFor(Class<?> clz, Set<Class<?>> visited) {
        if (clz.getSuperclass() == null) {
            return;
        }
        this.typesFor(clz.getSuperclass(), visited);
        Arrays.stream(clz.getInterfaces()).forEach(i -> this.typesFor((Class<?>)i, visited));
        visited.add(clz);
    }

    @Override
    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        if (target.getClass() == Class.class) {
            this.registerClass((Class)target);
        } else {
            this.registerObject(target);
        }
    }

    private void registerListener(Object target, Method method, Method real) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + eventType);
        }
        this.register(eventType, target, real);
    }

    private void register(Class<?> eventType, Object target, Method method) {
        try {
            ASMEventHandler asm;
            Constructor<?> ctr = eventType.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            ASMEventHandler listener = asm = new ASMEventHandler(target, method, IGenericEvent.class.isAssignableFrom(eventType));
            event.getListenerList().register(this.busID, asm.getPriority(), listener);
            ArrayList others = this.listeners.computeIfAbsent(target, k -> new ArrayList());
            others.add(listener);
        }
        catch (Exception e) {
            LogManager.getLogger((String)"EVENTBUS").error("Error registering event handler: {} {}", eventType, (Object)method, (Object)e);
        }
    }

    @Override
    public void unregister(Object object) {
        ArrayList<IEventListener> list = this.listeners.remove(object);
        if (list == null) {
            return;
        }
        for (IEventListener listener : list) {
            ListenerList.unregisterAll(this.busID, listener);
        }
    }

    @Override
    public boolean post(Event event) {
        int index;
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        try {
            for (index = 0; index < listeners.length; ++index) {
                listeners[index].invoke(event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, listeners, index, throwable);
            throw new RuntimeException(throwable);
        }
        return event.isCancelable() ? event.isCanceled() : false;
    }

    @Override
    public void handleException(IEventBus bus, Event event, IEventListener[] listeners, int index, Throwable throwable) {
        LogManager.getLogger((String)"EVENTBUS").error(Logging.EVENTBUS, () -> new EventBusErrorMessage(event, index, listeners, throwable));
    }
}

