/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.minecraftforge.eventbus.Logging;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventAccessTransformer {
    public ClassNode transform(ClassNode classNode, Type classType) {
        classNode.methods.stream().filter(m -> Optional.ofNullable(m.visibleAnnotations).orElse(Collections.emptyList()).stream().anyMatch(a -> Objects.equals(a.desc, "Lnet/minecraftforge/eventbus/api/SubscribeEvent;"))).peek(m -> {
            if (Modifier.isPrivate(m.access)) {
                this.illegalPrivateAccess((MethodNode)m, classNode);
            }
        }).filter(m -> !Modifier.isPrivate(m.access)).peek($ -> {
            classNode.access = EventAccessTransformer.changeAccess(classNode.access);
        }).forEach(this::toPublic);
        return classNode;
    }

    private void illegalPrivateAccess(MethodNode mn, ClassNode cn) {
        LogManager.getLogger((String)"EVENTBUS").error(Logging.EVENTBUS, "Illegal private member annotated as @SubscribeEvent : {}.{}", (Object)cn.name, (Object)mn.name);
        throw new RuntimeException("Illegal private member with @SubscribeEvent annotation");
    }

    private static int changeAccess(int access) {
        return access & 0xFFFFFFF9 | 1;
    }

    private void toPublic(MethodNode mn) {
        mn.access = EventAccessTransformer.changeAccess(mn.access);
    }
}

