/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.depigifier.IMapper;
import net.minecraftforge.depigifier.model.Class;

public class Tree
implements IMapper {
    private Map<String, String> packages = new HashMap<String, String>();
    private Map<String, Class> o2nClasses = new HashMap<String, Class>();
    private Map<String, Class> n2oClasses = new HashMap<String, Class>();
    private final Map<String, Set<Class>> references = new HashMap<String, Set<Class>>();

    public void addPackage(String oldPkg, String newPkg) {
        this.packages.put(oldPkg, newPkg);
    }

    public Class getClass(String oldName) {
        return this.o2nClasses.computeIfAbsent(oldName, k -> new Class(this, oldName));
    }

    public Class tryClass(String oldName) {
        return this.o2nClasses.get(oldName);
    }

    public Collection<Class> getClasses() {
        return this.o2nClasses.values();
    }

    public Set<String> getClassNames() {
        return this.o2nClasses.keySet();
    }

    @Override
    public String mapClass(String cls) {
        Class _cls = this.o2nClasses.get(cls);
        if (_cls != null) {
            return _cls.getNewName();
        }
        int idx = cls.lastIndexOf(36);
        if (idx > 0) {
            return this.mapClass(cls.substring(0, idx)) + cls.substring(idx);
        }
        return cls;
    }

    @Override
    public String mapField(String cls, String field) {
        Class _cls = this.o2nClasses.get(cls);
        return _cls == null ? field : _cls.mapField(field);
    }

    @Override
    public String mapMethod(String cls, String method, String desc) {
        Class _cls = this.o2nClasses.get(cls);
        return _cls == null ? method : _cls.mapMethod(method, desc);
    }

    void renameClass(Class cls, String newName) {
        this.n2oClasses.remove(cls.getNewName());
        this.n2oClasses.put(newName, cls);
        this.references.getOrDefault(cls.getOldName(), Collections.emptySet()).forEach(c -> c.classRenamed((Class)c, new RenamedMapper(cls.getOldName(), newName)));
    }

    void addReference(String cls, Class listener) {
        this.references.computeIfAbsent(cls, k -> new HashSet()).add(listener);
    }

    private class RenamedMapper
    implements IMapper {
        private final String oldName;
        private final String newName;

        private RenamedMapper(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public String mapClass(String cls) {
            if (this.oldName.equals(cls)) {
                return this.newName;
            }
            return Tree.this.mapClass(cls);
        }

        @Override
        public String mapField(String cls, String field) {
            return Tree.this.mapField(cls, field);
        }

        @Override
        public String mapMethod(String cls, String method, String desc) {
            return Tree.this.mapMethod(cls, method, desc);
        }
    }
}

