/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier.model;

import net.minecraftforge.depigifier.IMapper;
import net.minecraftforge.depigifier.model.Class;
import org.objectweb.asm.Type;

public class Method {
    private final Class owner;
    private final String oldName;
    private final String desc;
    private final Type[] args;
    private final Type retType;
    private String newName;
    private int start = -1;
    private int end = -1;

    public Method(Class owner, String name, String desc) {
        this.owner = owner;
        this.oldName = name;
        this.newName = name;
        this.desc = desc;
        this.args = Type.getArgumentTypes((String)desc);
        this.retType = Type.getReturnType((String)desc);
        for (Type arg : this.args) {
            if (arg.getSort() == 9) {
                arg = arg.getElementType();
            }
            if (arg.getSort() != 10) continue;
            this.getOwner().addReference(arg.getInternalName(), this);
        }
    }

    public Method setLines(int start, int end) {
        this.start = start;
        this.end = end;
        return this;
    }

    public Method rename(String newName) {
        this.getOwner().renameMethod(this, newName);
        this.newName = newName;
        return this;
    }

    public String toString() {
        return (this.hasLines() ? "(" + this.getStart() + ":" + this.getEnd() + ") " : "") + this.getOwner().getOldName() + "." + this.getOldName() + this.getOldDesc();
    }

    public String getOldDesc() {
        return this.desc;
    }

    public String getNewDesc(IMapper mapper) {
        return mapper.mapDescriptor(this.args, this.retType);
    }

    public Class getOwner() {
        return this.owner;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public boolean hasLines() {
        return this.start != -1 && this.end != -1;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

