/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier.model;

import net.minecraftforge.depigifier.model.Class;

public class Field {
    private final Class owner;
    private final String oldName;
    private String newName;
    private String desc;

    public Field(Class owner, String name) {
        this.owner = owner;
        this.oldName = name;
        this.newName = name;
    }

    public Field setType(String desc) {
        this.desc = desc;
        return this;
    }

    public Field rename(String newName) {
        this.owner.renameField(this, newName);
        this.newName = newName;
        return this;
    }

    public String toString() {
        return "(" + (this.desc == null ? "unknown" : this.desc) + ") " + this.owner.getOldName() + "." + this.oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getType() {
        return this.desc;
    }

    public Class getOwner() {
        return this.owner;
    }
}

