/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.depigifier.IMapper;
import net.minecraftforge.depigifier.model.Field;
import net.minecraftforge.depigifier.model.Method;
import net.minecraftforge.depigifier.model.Tree;

public class Class {
    private final Map<String, Field> o2nFields = new HashMap<String, Field>();
    private final Map<String, Field> n2oFields = new HashMap<String, Field>();
    private final Map<String, Method> o2nMethods = new HashMap<String, Method>();
    private final Map<String, Method> n2oMethods = new HashMap<String, Method>();
    private final Map<String, Set<Method>> references = new HashMap<String, Set<Method>>();
    private final Tree tree;
    private final String oldName;
    private String newName;

    Class(Tree tree, String name) {
        this.tree = tree;
        this.oldName = name;
        this.newName = name;
    }

    public String toString() {
        return "CL: " + this.oldName + " " + this.newName;
    }

    public Class rename(String newName) {
        this.tree.renameClass(this, newName);
        this.newName = newName;
        return this;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public Field getField(String name) {
        return this.o2nFields.computeIfAbsent(name, k -> new Field(this, name));
    }

    public Field tryField(String name) {
        return this.o2nFields.get(name);
    }

    public Collection<Field> getFields() {
        return this.o2nFields.values();
    }

    public Set<String> getFieldNames() {
        return this.o2nFields.keySet();
    }

    public Method getMethod(String name, String desc) {
        return this.o2nMethods.computeIfAbsent(name + desc, k -> new Method(this, name, desc));
    }

    public Method tryMethod(String name, String desc) {
        return this.o2nMethods.get(name + desc);
    }

    public Collection<Method> getMethods() {
        return this.o2nMethods.values();
    }

    public Set<String> getMethodSignatures() {
        return this.o2nMethods.keySet();
    }

    public String mapField(String field) {
        Field fld = this.o2nFields.get(field);
        return fld == null ? field : fld.getNewName();
    }

    public String mapMethod(String method, String desc) {
        Method mtd = this.o2nMethods.get(method + desc);
        return mtd == null ? method : mtd.getNewName();
    }

    void renameField(Field field, String newName) {
        this.n2oFields.remove(field.getNewName());
        this.n2oFields.put(newName, field);
    }

    void renameMethod(Method method, String newName) {
        String desc = method.getNewDesc(this.tree);
        this.n2oMethods.remove(method.getNewName() + desc);
        this.n2oMethods.put(newName + desc, method);
    }

    void addReference(String cls, Method method) {
        this.references.computeIfAbsent(cls, k -> new HashSet()).add(method);
        this.tree.addReference(cls, this);
    }

    void classRenamed(Class cls, IMapper mapper) {
        this.references.getOrDefault(cls.getOldName(), Collections.emptySet()).forEach(m -> {
            this.n2oMethods.remove(m.getNewName() + m.getNewDesc(this.tree));
            this.n2oMethods.put(m.getNewName() + m.getNewDesc(mapper), (Method)m);
        });
    }
}

