/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier;

import com.machinezoo.noexception.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.depigifier.MappingFile;
import net.minecraftforge.depigifier.Matcher;
import net.minecraftforge.depigifier.model.Tree;

public class Unpig {
    public static void main(String ... args) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec manualMapFile = optionParser.accepts("mapping", "Mapping file containing manual matches").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE}));
        ArgumentAcceptingOptionSpec oldPGFile = optionParser.accepts("oldPG", "Old ProGuard file").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE})).required();
        ArgumentAcceptingOptionSpec newPGFile = optionParser.accepts("newPG", "New ProGuard file").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE})).required();
        ArgumentAcceptingOptionSpec outDir = optionParser.accepts("out", "Directory to output to").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0])).defaultsTo((Object)Paths.get("output", new String[0]), (Object[])new Path[0]);
        AbstractOptionSpec forHelp = optionParser.accepts("help", "Help").forHelp();
        OptionSet argset = null;
        try {
            argset = optionParser.parse(args);
        }
        catch (OptionException e) {
            System.out.println(e.getMessage());
            Exceptions.sneak().run(() -> optionParser.printHelpOn((OutputStream)System.out));
            System.exit(1);
        }
        if (argset.has((OptionSpec)forHelp)) {
            Exceptions.sneak().run(() -> optionParser.printHelpOn((OutputStream)System.out));
            System.exit(1);
        }
        Path oldPG = (Path)argset.valueOf((OptionSpec)oldPGFile);
        Path newPG = (Path)argset.valueOf((OptionSpec)newPGFile);
        Path output = (Path)argset.valueOf((OptionSpec)outDir);
        Path manualMap = (Path)argset.valueOf((OptionSpec)manualMapFile);
        Tree oldTree = MappingFile.load(oldPG, true);
        Tree newTree = MappingFile.load(newPG, true);
        if (!Files.exists(output, new LinkOption[0])) {
            try {
                Files.createDirectories(output, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.println("Failed to create output directory: " + output);
                e.printStackTrace();
                System.exit(1);
            }
        }
        Matcher comp = new Matcher(oldTree, newTree, output);
        if (argset.has((OptionSpec)manualMapFile)) {
            Tree manualMappings = MappingFile.load(manualMap, false);
            comp.addMapper(manualMappings);
        }
        comp.computeClassListDifferences();
        comp.compareExistingClasses();
    }
}

