/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier;

import com.machinezoo.noexception.Exceptions;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.depigifier.IMapper;
import net.minecraftforge.depigifier.SetDifference;
import net.minecraftforge.depigifier.Sorters;
import net.minecraftforge.depigifier.model.Class;
import net.minecraftforge.depigifier.model.Field;
import net.minecraftforge.depigifier.model.Method;
import net.minecraftforge.depigifier.model.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(Matcher.class);
    private final Tree oldTree;
    private final Tree newTree;
    private final Path outputDir;
    private final List<IMapper> mappers = new ArrayList<IMapper>();
    private List<Class> existingClasses;
    private Map<Class, Class> forcedClasses = new HashMap<Class, Class>();
    private Map<Field, Field> forcedFields = new HashMap<Field, Field>();
    private Map<Method, Method> forcedMethods = new HashMap<Method, Method>();
    private List<Class> newClasses = new ArrayList<Class>();
    private List<Field> newFields = new ArrayList<Field>();
    private List<Method> newMethods = new ArrayList<Method>();
    private List<Class> missingClasses = new ArrayList<Class>();
    private List<Field> missingFields = new ArrayList<Field>();
    private List<Method> missingMethods = new ArrayList<Method>();

    public Matcher(Tree oldTree, Tree newTree, Path output) {
        this.oldTree = oldTree;
        this.newTree = newTree;
        this.outputDir = output;
    }

    private static String fieldToTSRGString(Field f) {
        return f.getOwner().getOldName() + " " + f.getOldName();
    }

    private static String methodToTSRGString(Method m) {
        return m.getOwner().getOldName() + " " + m.getOldName() + " " + m.getOldDesc();
    }

    public void computeClassListDifferences() {
        this.existingClasses = new ArrayList<Class>();
        this.differenceSet(this.oldTree::getClassNames, this.newTree::getClassNames, this::mapClass, this.oldTree::tryClass, this.newTree::tryClass, this.forcedClasses::put, () -> this.newClasses, () -> this.existingClasses, () -> this.missingClasses);
        this.writeFile(this.outputDir.resolve("newclasses.txt"), this.listBuilder(() -> this.newClasses, Class::getOldName));
        this.writeFile(this.outputDir.resolve("missingclasses.txt"), this.listBuilder(() -> this.missingClasses, Class::getOldName));
        System.out.println("missing/new/total");
        System.out.println("Classes: " + this.missingClasses.size() + "/" + this.newClasses.size() + "/" + this.newTree.getClasses().size());
    }

    public void compareExistingClasses() {
        this.existingClasses.forEach(aClass -> this.compareClass((Class)aClass, this.newFields, this.newMethods, this.missingFields, this.missingMethods));
        this.writeFile(this.outputDir.resolve("newfields.txt"), this.listBuilder(() -> this.newFields, Matcher::fieldToTSRGString));
        this.writeFile(this.outputDir.resolve("missingfields.txt"), this.listBuilder(() -> this.missingFields, Matcher::fieldToTSRGString));
        this.writeFile(this.outputDir.resolve("newmethods.txt"), this.listBuilder(() -> this.newMethods, Matcher::methodToTSRGString));
        this.writeFile(this.outputDir.resolve("missingmethods.txt"), this.listBuilder(() -> this.missingMethods, Matcher::methodToTSRGString));
        Path tsrgOut = this.outputDir.resolve("oldtonew.tsrg");
        ArrayList tsrgLines = new ArrayList();
        this.existingClasses.stream().sorted(Comparator.comparing(aClass -> this.forcedClasses.get(aClass).getNewName(), Comparator.comparingInt(String::length).thenComparing(String::compareTo))).forEach(cl -> this.buildTSRG((Class)cl, tsrgLines));
        Exceptions.sneak().run(() -> Files.write(tsrgOut, (Iterable<? extends CharSequence>)tsrgLines, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
        System.out.println("Fields : " + this.missingFields.size() + "/" + this.newFields.size() + "/" + this.newTree.getClasses().stream().mapToInt(c -> c.getFields().size()).sum());
        System.out.println("Methods: " + this.missingMethods.size() + "/" + this.newMethods.size() + "/" + this.newTree.getClasses().stream().mapToInt(c -> c.getMethods().size()).sum());
        this.dumpMagiDots();
        this.missingClasses.stream().sorted((c1, c2) -> c1.getOldName().compareTo(c2.getOldName())).forEach(m -> {
            String name = m.getOldName().substring(m.getOldName().lastIndexOf(47) + 1);
            if (!name.equals("package-info")) {
                List<String> lst = this.newClasses.stream().map(Class::getOldName).filter(n -> n.endsWith(name)).collect(Collectors.toList());
                if (lst.size() == 1) {
                    System.out.println(m.getOldName() + " " + (String)lst.get(0));
                } else if (!lst.isEmpty()) {
                    System.out.println(m.getOldName());
                    lst.forEach(l -> System.out.println("  " + l));
                }
            }
        });
    }

    private void dumpMagiDots() {
        Function<Field, String> fts = f -> f.getOwner().getNewName() + "." + f.getNewName();
        BiFunction<Method, Tree, String> mts = (m, t) -> m.getOwner().getNewName() + "." + m.getNewName() + " " + m.getNewDesc((IMapper)t);
        this.writeFile(this.outputDir.resolve("joined_forced.txt"), () -> {
            List clss = this.forcedClasses.keySet().stream().map(nw -> this.forcedClasses.get(nw).getNewName() + " " + nw.getNewName()).collect(Collectors.toList());
            Collections.sort(clss, (o1, o2) -> Sorters.CLASSES.compare(o1.split(" ")[0], o2.split(" ")[0]));
            clss.add(0, "[CLASSES]");
            List flds = this.forcedFields.keySet().stream().map(nw -> (String)fts.apply(this.forcedFields.get(nw)) + " " + (String)fts.apply((Field)nw)).collect(Collectors.toList());
            Collections.sort(flds, (o1, o2) -> Sorters.FIELDS.compare(o1.split(" ")[0], o2.split(" ")[0]));
            flds.add(0, "[FIELDS]");
            List mtds = this.forcedMethods.keySet().stream().map(nw -> (String)mts.apply(this.forcedMethods.get(nw), this.oldTree) + " " + (String)mts.apply((Method)nw, this.newTree)).collect(Collectors.toList());
            Collections.sort(mtds, (o1, o2) -> Sorters.METHODS.compare(o1.split(" ")[0] + " " + o1.split(" ")[1], o2.split(" ")[0] + " " + o2.split(" ")[1]));
            mtds.add(0, "[METHODS]");
            clss.addAll(flds);
            clss.addAll(mtds);
            return clss;
        });
    }

    private void buildTSRG(Class nw, List<String> tsrgLines) {
        tsrgLines.add(this.forcedClasses.get(nw).getNewName() + " " + nw.getNewName());
        tsrgLines.addAll(nw.getFields().stream().filter(f -> Objects.nonNull(this.forcedFields.get(f))).map(f -> "\t" + this.forcedFields.get(f).getNewName() + " " + f.getNewName()).sorted().collect(Collectors.toList()));
        tsrgLines.addAll(nw.getMethods().stream().filter(m -> Objects.nonNull(this.forcedMethods.get(m))).map(m -> "\t" + this.forcedMethods.get(m).getNewName() + " " + this.forcedMethods.get(m).getNewDesc(this.oldTree) + " " + m.getNewName()).sorted().collect(Collectors.toList()));
    }

    private <T> Supplier<List<String>> listBuilder(Supplier<Collection<T>> t, Function<T, String> stringFunction) {
        return () -> ((Collection)t.get()).stream().map(stringFunction).sorted().collect(Collectors.toList());
    }

    private void writeFile(Path path, Supplier<List<String>> lines) {
        Exceptions.sneak().run(() -> Files.write(path, (Iterable<? extends CharSequence>)((Iterable)lines.get()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
    }

    private <T> void differenceSet(Supplier<Set<String>> old, Supplier<Set<String>> nw, Function<String, String> oldNameTransformer, Function<String, T> oldLookup, Function<String, T> newLookup, BiConsumer<T, T> connector, Supplier<List<T>> newTracker, Supplier<List<T>> existingTracker, Supplier<List<T>> missingTracker) {
        Map<String, String> transformedOldNames = old.get().stream().map(o -> new AbstractMap.SimpleImmutableEntry(oldNameTransformer.apply((String)o), (String)o)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        SetDifference<String> sd = new SetDifference<String>(transformedOldNames.keySet(), nw.get());
        HashSet<String> newValues = sd.getRightOnly();
        HashSet<String> missingValues = sd.getLeftOnly();
        HashSet<String> matchedValues = sd.getCommon();
        List commonValues = matchedValues.stream().map(n -> new AbstractMap.SimpleImmutableEntry(oldLookup.apply((String)transformedOldNames.get(n)), newLookup.apply((String)n))).peek(e -> connector.accept(e.getValue(), e.getKey())).map(AbstractMap.SimpleImmutableEntry::getValue).collect(Collectors.toList());
        missingTracker.get().addAll(missingValues.stream().map(n -> oldLookup.apply((String)transformedOldNames.get(n))).collect(Collectors.toList()));
        existingTracker.get().addAll(commonValues);
        newTracker.get().addAll(newValues.stream().map(newLookup).collect(Collectors.toList()));
    }

    private void compareClass(Class entry, List<Field> newFieldTracked, List<Method> newMethodTracked, List<Field> missingFields, List<Method> missingMethods) {
        Class old = this.forcedClasses.get(entry);
        Class nw = entry;
        BiFunction<Class, String, Method> tryMethod = (cls, sig) -> {
            int idx = sig.indexOf(40);
            return cls.tryMethod(sig.substring(0, idx), sig.substring(idx));
        };
        this.differenceSet(old::getFieldNames, nw::getFieldNames, fld -> this.mapField(old.getOldName(), (String)fld), old::tryField, nw::tryField, this.forcedFields::put, () -> newFieldTracked, ArrayList::new, () -> missingFields);
        this.differenceSet(old::getMethodSignatures, nw::getMethodSignatures, s -> this.mapMethod(old.getOldName(), (String)s), sig -> (Method)tryMethod.apply(old, (String)sig), sig -> (Method)tryMethod.apply(nw, (String)sig), this.forcedMethods::put, () -> newMethodTracked, ArrayList::new, () -> missingMethods);
    }

    public void addMapper(IMapper mapper) {
        this.mappers.add(mapper);
    }

    private String mapClass(String cls) {
        for (IMapper mapper : this.mappers) {
            cls = mapper.mapClass(cls);
        }
        return cls;
    }

    private String mapField(String cls, String fld) {
        for (IMapper mapper : this.mappers) {
            fld = mapper.mapField(cls, fld);
            cls = mapper.mapClass(cls);
        }
        return fld;
    }

    private String mapMethod(String cls, String sig) {
        int idx = sig.indexOf(40);
        String mtd = sig.substring(0, idx);
        String desc = sig.substring(idx);
        for (IMapper mapper : this.mappers) {
            mtd = mapper.mapMethod(cls, mtd, desc);
            cls = mapper.mapClass(cls);
            desc = mapper.mapDescriptor(desc);
        }
        return mtd + desc;
    }
}

