/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier;

import com.machinezoo.noexception.Exceptions;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.depigifier.ClassLookup;
import net.minecraftforge.depigifier.model.Class;
import net.minecraftforge.depigifier.model.Method;
import net.minecraftforge.depigifier.model.Tree;

public class MappingFile {
    public static Tree load(Path file, boolean filterInits) {
        List lines = ((List)Exceptions.sneak().get(() -> Files.readAllLines(file))).stream().map(l -> {
            int idx = l.indexOf(35);
            if (idx == -1) {
                return l;
            }
            while (idx > 0 && Character.isWhitespace(l.charAt(idx))) {
                --idx;
            }
            return idx > 0 ? l.substring(0, idx - 1) : "";
        }).filter(l -> !l.isEmpty()).collect(Collectors.toList());
        if (lines.isEmpty()) {
            throw new IllegalArgumentException("Tried to load mapping file with no entries");
        }
        Tree tree = new Tree();
        String first = (String)lines.get(0);
        if (first.length() > 3 && Arrays.asList("PK:", "CL:", "FD:", "MD:").contains(first.substring(0, 3))) {
            for (String line : lines) {
                String[] pts = line.split(" ");
                if ("PK:".equals(pts[0])) {
                    tree.addPackage(pts[1].equals(".") ? "" : pts[1], pts[2].equals(".") ? "" : pts[2]);
                    continue;
                }
                if ("CL:".equals(pts[0])) {
                    tree.getClass(pts[1]).rename(pts[2]);
                    continue;
                }
                if ("FD:".equals(pts[0])) {
                    tree.getClass(MappingFile.getClass(pts[1])).getField(MappingFile.getName(pts[1])).rename(MappingFile.getName(pts[2]));
                    continue;
                }
                if (!"MD:".equals(pts[0])) continue;
                String name = MappingFile.getName(pts[1]);
                if (filterInits && name.startsWith("<")) continue;
                tree.getClass(MappingFile.getClass(pts[1])).getMethod(MappingFile.getName(pts[1]), pts[2]).rename(MappingFile.getName(pts[3]));
            }
        } else if (first.contains(" -> ")) {
            Class current = null;
            for (String line : lines) {
                String[] pts = line.trim().split(" ");
                if (!line.startsWith("    ")) {
                    current = tree.getClass(pts[0].replace('.', '/'));
                    current.rename(pts[2].substring(0, pts[2].length() - 1).replace('.', '/'));
                    continue;
                }
                if (!line.contains("(")) {
                    if (current == null) {
                        throw new IllegalArgumentException("Tried to load an invalid Proguard file, missing current class: " + line);
                    }
                    current.getField(pts[1]).setType(ClassLookup.transformSignature(pts[0])).rename(pts[3]);
                    continue;
                }
                if (current == null) {
                    throw new IllegalArgumentException("Tried to load an invalid Proguard file, missing current class: " + line);
                }
                int start = -1;
                int end = -1;
                if (pts[0].indexOf(58) != -1) {
                    String[] s = pts[0].split(":");
                    start = Exceptions.silence().get(() -> Integer.parseInt(s[0])).orElse(-1);
                    end = Exceptions.silence().get(() -> Integer.parseInt(s[1])).orElse(-1);
                    pts[0] = s[2];
                }
                int idx = pts[1].indexOf("(");
                String name = pts[1].substring(0, idx);
                if (filterInits && name.startsWith("<")) continue;
                String desc = "(" + Arrays.stream(pts[1].substring(idx + 1, pts[1].length() - 1).split(",")).map(ClassLookup::transformSignature).collect(Collectors.joining()) + ")" + ClassLookup.transformSignature(pts[0]);
                Method mtd = current.getMethod(name, desc);
                if (start != -1 && end != -1) {
                    mtd.setLines(start, end);
                }
                mtd.rename(pts[3]);
            }
        } else {
            Class current = null;
            for (String line : lines) {
                String[] pts;
                if (line.charAt(0) == '\t') {
                    if (current == null) {
                        throw new IllegalArgumentException("Tried to load an invalid TSRG file, missing current class: " + line);
                    }
                    pts = line.substring(1).split(" ");
                    if (pts.length == 2) {
                        current.getField(pts[0]).rename(pts[1]);
                        continue;
                    }
                    if (pts.length != 3 || filterInits && pts[0].startsWith("<")) continue;
                    current.getMethod(pts[0], pts[1]).rename(pts[2]);
                    continue;
                }
                pts = line.split(" ");
                if (pts.length == 2 && pts[0].endsWith("/") && pts[1].endsWith("/")) {
                    tree.addPackage(pts[0].substring(0, pts[0].length() - 1), pts[1].substring(0, pts[1].length() - 1));
                    continue;
                }
                if (pts.length == 2) {
                    current = tree.getClass(pts[0]).rename(pts[1]);
                    continue;
                }
                if (pts.length == 3) {
                    tree.getClass(pts[0]).getField(pts[1]).rename(pts[2]);
                    continue;
                }
                if (pts.length != 4 || filterInits && pts[0].startsWith("<")) continue;
                tree.getClass(pts[0]).getMethod(pts[1], pts[2]).rename(pts[3]);
            }
        }
        return tree;
    }

    private static String getName(String fullPath) {
        int idx = fullPath.lastIndexOf(47);
        return idx == -1 ? fullPath : fullPath.substring(idx);
    }

    private static String getClass(String fullPath) {
        int idx = fullPath.lastIndexOf(47);
        return idx == -1 ? fullPath : fullPath.substring(0, idx);
    }
}

