/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.depigifier;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;

public class ClassLookup {
    private static final List<String> PRIMITIVES = Arrays.asList("void", "boolean", "char", "byte", "short", "int", "float", "long", "double");
    private static final String PRIMS = "VZCBSIFJD";

    public static String transformMethodNoObf(String[] args, String ret) {
        String argstring = Arrays.stream(args).map(ClassLookup::transformSignature).collect(Collectors.joining());
        return "(" + argstring + ")" + ClassLookup.transformSignature(ret);
    }

    public static String transformNoObf(String input) {
        return ClassLookup.transformName(input, m -> m);
    }

    public static String transformName(String input, Function<String, String> remapper) {
        return remapper.apply(input);
    }

    public static String transformSignature(String input) {
        if (input.length() == 0) {
            return input;
        }
        int arr = input.split("\\[").length - 1;
        String array = Strings.repeat((char)'[', (int)arr);
        String name = input.substring(0, input.length() - arr * 2);
        int idx = PRIMITIVES.indexOf(name);
        if (idx > -1) {
            return array + PRIMS.charAt(idx);
        }
        return array + 'L' + name.replace('.', '/') + ';';
    }

    public static String cleanInternalName(String name) {
        if (name.endsWith(";")) {
            return name.substring(name.indexOf(76), name.length() - 1);
        }
        return name;
    }
}

