/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod;

import cpw.mods.modlauncher.api.ITransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import net.minecraftforge.coremod.CoreMod;
import net.minecraftforge.forgespi.coremod.ICoreModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoreModEngine {
    private static final Logger LOGGER = LogManager.getLogger((String)"CoreMod");
    private List<CoreMod> coreMods = new ArrayList<CoreMod>();
    private static final List<String> ALLOWED_PACKAGES = Arrays.asList("org.objectweb.asm.");

    void loadCoreMod(ICoreModFile coremod) {
        NashornScriptEngineFactory nashornScriptEngineFactory = new NashornScriptEngineFactory();
        ScriptEngine scriptEngine = nashornScriptEngineFactory.getScriptEngine(s -> ALLOWED_PACKAGES.stream().anyMatch(s::startsWith));
        this.coreMods.add(new CoreMod(coremod, scriptEngine));
    }

    public List<ITransformer<?>> initializeCoreMods() {
        this.coreMods.forEach(this::initialize);
        return this.coreMods.stream().map(CoreMod::buildTransformers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void initialize(CoreMod coreMod) {
        LOGGER.debug("Loading CoreMod from {}", (Object)coreMod.getPath());
        coreMod.initialize();
        if (coreMod.hasError()) {
            LOGGER.error("Error occurred initializing CoreMod", (Throwable)coreMod.getError());
        } else {
            LOGGER.debug("CoreMod loaded successfully");
        }
    }
}

