/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Set;
import javax.annotation.Nonnull;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import net.minecraftforge.coremod.CoreMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.tree.ClassNode;

public class CoreModClassTransformer
implements ITransformer<ClassNode> {
    private static final Logger LOGGER = LogManager.getLogger((String)"CoreMod");
    private static final Marker XFORM_MARKER = MarkerManager.getMarker((String)"XFORM");
    private final CoreMod coreMod;
    private final Set<ITransformer.Target> targets;
    private final ScriptObjectMirror function;
    private final String coreName;

    CoreModClassTransformer(CoreMod coreMod, String coreName, Set<ITransformer.Target> targets, ScriptObjectMirror function) {
        this.coreMod = coreMod;
        this.coreName = coreName;
        this.targets = targets;
        this.function = function;
    }

    @Nonnull
    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        LOGGER.debug(XFORM_MARKER, "Transforming {}", (Object)input.name);
        ClassNode result = input;
        try {
            result = (ClassNode)this.function.call((Object)this.function, new Object[]{input});
        }
        catch (Exception e) {
            LOGGER.error(XFORM_MARKER, "Error occurred applying transform of coremod {} function {}", (Object)e, (Object)this.coreMod.getPath(), (Object)this.coreName);
        }
        return result;
    }

    @Nonnull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @Nonnull
    public Set<ITransformer.Target> targets() {
        return this.targets;
    }
}

