/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod;

import cpw.mods.modlauncher.api.ITransformer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import net.minecraftforge.coremod.CoreModClassTransformer;
import net.minecraftforge.forgespi.coremod.ICoreModFile;

public class CoreMod {
    private final ICoreModFile file;
    private final ScriptEngine scriptEngine;
    private Map<String, ScriptObjectMirror> javaScript;
    private boolean loaded = false;
    private Exception error;

    CoreMod(ICoreModFile file, ScriptEngine scriptEngine) {
        this.file = file;
        this.scriptEngine = scriptEngine;
    }

    public Path getPath() {
        return this.file.getPath();
    }

    void initialize() {
        try {
            ScriptObjectMirror som = (ScriptObjectMirror)this.scriptEngine.eval(this.file.readCoreMod());
            this.javaScript = (Map)((Invocable)((Object)this.scriptEngine)).invokeFunction("initializeCoreMod", new Object[0]);
            this.loaded = true;
        }
        catch (IOException | NoSuchMethodException | ScriptException e) {
            this.loaded = false;
            this.error = e;
        }
    }

    List<ITransformer<?>> buildTransformers() {
        if (!this.loaded) {
            return Collections.emptyList();
        }
        return this.javaScript.entrySet().stream().map(this::buildCore).collect(Collectors.toList());
    }

    private ITransformer<?> buildCore(Map.Entry<String, ScriptObjectMirror> entry) {
        String coreName = entry.getKey();
        ScriptObjectMirror data = entry.getValue();
        ScriptObjectMirror targetData = (ScriptObjectMirror)data.getMember("target");
        ITransformer.TargetType targetType = ITransformer.TargetType.valueOf((String)((String)targetData.getMember("type")));
        ScriptObjectMirror function = (ScriptObjectMirror)data.getMember("transformer");
        switch (targetType) {
            case CLASS: {
                Set<ITransformer.Target> targets = targetData.hasMember("names") ? ((ScriptObjectMirror)((ScriptObjectMirror)targetData.getMember("names")).call((Object)targetData, new Object[0])).values().stream().map(o -> (String)o).map(ITransformer.Target::targetClass).collect(Collectors.toSet()) : Stream.of(ITransformer.Target.targetClass((String)((String)targetData.get((Object)"name")))).collect(Collectors.toSet());
                return new CoreModClassTransformer(this, coreName, targets, function);
            }
        }
        Set targets = Collections.emptySet();
        return null;
    }

    public boolean hasError() {
        return !this.loaded;
    }

    public Exception getError() {
        return this.error;
    }
}

