/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.binarypatcher;

import java.io.File;
import java.io.IOException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.binarypatcher.Generator;
import net.minecraftforge.binarypatcher.Patcher;

public class ConsoleTool {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> clean = parser.accepts("clean").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> output = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> create = parser.accepts("create").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> patches = parser.accepts("patches").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> srg = parser.accepts("srg").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> apply = parser.accepts("apply").withRequiredArg().ofType(File.class);
        OptionSpecBuilder data = parser.accepts("data");
        OptionSpecBuilder unpatched = parser.accepts("unpatched");
        try {
            OptionSet options = parser.parse(args);
            File clean_jar = options.valueOf(clean);
            File output_jar = options.valueOf(output).getAbsoluteFile();
            if (output_jar.exists() && !output_jar.delete()) {
                System.out.println("Could not delete output file: " + output_jar);
                return;
            }
            if (!output_jar.getParentFile().exists() && !output_jar.getParentFile().mkdirs()) {
                System.out.println("Could not make output folders: " + output_jar.getParentFile());
                return;
            }
            if (options.has(create) && options.has(apply)) {
                System.out.println("Cannot specify --apply and --create at the same time!");
                return;
            }
            if (options.has(create)) {
                if (options.has(data)) {
                    System.out.println("Connot specify --data and --create at the same time!");
                    return;
                }
                if (options.has(unpatched)) {
                    System.out.println("Connot specify --unpatched and --create at the same time!");
                    return;
                }
                File dirty_jar = options.valueOf(create);
                Generator gen = new Generator(clean_jar, dirty_jar, output_jar);
                ConsoleTool.log("Generating: ");
                ConsoleTool.log("  Clean:   " + clean_jar);
                ConsoleTool.log("  Dirty:   " + dirty_jar);
                ConsoleTool.log("  Output:  " + output_jar);
                if (options.has(patches)) {
                    for (File dir : options.valuesOf(patches)) {
                        ConsoleTool.log("  Patches: " + dir);
                        gen.loadPatches(dir);
                    }
                }
                if (options.has(srg)) {
                    for (File file : options.valuesOf(srg)) {
                        ConsoleTool.log("  SRG:     " + file);
                        gen.loadMappings(file);
                    }
                }
                gen.create();
            } else if (options.has(apply)) {
                if (options.has(srg)) {
                    System.out.println("Connot specify --srg and --apply at the same time!");
                    return;
                }
                if (options.has(patches)) {
                    System.out.println("Connot specify --patches and --apply at the same time!");
                    return;
                }
                Patcher patcher = new Patcher(clean_jar, output_jar);
                ConsoleTool.log("Applying: ");
                ConsoleTool.log("  Clean:     " + clean_jar);
                ConsoleTool.log("  Output:    " + output_jar);
                ConsoleTool.log("  KeepData:  " + options.has(data));
                patcher.keepData(options.has(data));
                ConsoleTool.log("  Unpatched: " + options.has(unpatched));
                patcher.includeUnpatched(options.has(unpatched));
                for (File file : options.valuesOf(apply)) {
                    ConsoleTool.log("  Patches:   " + file);
                    patcher.loadPatches(file);
                }
                patcher.process();
            } else {
                parser.printHelpOn(System.out);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        System.out.println(message);
    }
}

