/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TFloatIntProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TFloatIntHashMap
extends TFloatHash
implements Serializable {
    protected transient int[] _values;

    public Object clone() {
        TFloatIntHashMap m3 = (TFloatIntHashMap)super.clone();
        m3._values = (int[])this._values.clone();
        return m3;
    }

    public TFloatIntIterator iterator() {
        return new TFloatIntIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    public int put(float key, int value) {
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            boolean bl = false;
            if (previousState == 0) {
                bl = true;
            }
            this.postInsertHook(bl);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public int get(float key) {
        int index = this.index(key);
        int n = 0;
        boolean bl = false;
        if (index < 0) {
            bl = true;
        }
        if (!bl) {
            n = this._values[index];
        }
        return n;
    }

    public void clear() {
        super.clear();
        float[] keys = this._set;
        int[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0f;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public int remove(float key) {
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatIntHashMap)) {
            return false;
        }
        TFloatIntHashMap that = (TFloatIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = 0;
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public float[] keys() {
        float[] keys = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatIntProcedure procedure) {
        byte[] states = this._states;
        float[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(float key, int amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            int val = stream.readInt();
            this.put(key, val);
        }
    }

    public TFloatIntHashMap() {
    }

    public TFloatIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatIntHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatIntHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class HashProcedure
    implements TFloatIntProcedure {
        private int h;

        public final int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, int value) {
            this.h += TFloatIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }

        private final /* synthetic */ void this() {
            this.h = 0;
        }

        private HashProcedure() {
            this.this();
        }
    }

    private static final class EqProcedure
    implements TFloatIntProcedure {
        private final TFloatIntHashMap _otherMap;

        public final boolean execute(float key, int value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(int v1, int v2) {
            boolean bl = false;
            if (v1 == v2) {
                bl = true;
            }
            return bl;
        }

        EqProcedure(TFloatIntHashMap otherMap) {
            this._otherMap = otherMap;
        }
    }
}

