/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.gradle;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.UnaryOperator;

public class ReflectionUtils {
    public static <T> void alter(Object target, String name, UnaryOperator<T> operator) {
        try {
            Field f;
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                if ((target = ReflectionUtils.drillField(target, name.substring(0, idx))) == null) {
                    throw new IllegalStateException("Could not find field '" + name + "'");
                }
                name = name.substring(idx + 1);
            }
            if ((f = ReflectionUtils.findField(target.getClass(), name)) == null) {
                throw new IllegalStateException("Could not find '" + name + "'");
            }
            f.set(target, operator.apply(f.get(target)));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Object drillField(Object obj, String path) {
        for (String name : path.split("\\.")) {
            if (obj == null) {
                return null;
            }
            Field f = ReflectionUtils.findField(obj.getClass(), name);
            if (f == null) {
                return null;
            }
            try {
                obj = f.get(obj);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return obj;
    }

    private static Field findField(Class<?> clazz, String name) {
        while (clazz != Object.class) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getName().equals(name)) continue;
                f.setAccessible(true);
                if ((f.getModifiers() & 0x10) != 0) {
                    try {
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
                return f;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static <T> T invoke(Object target, Class<?> type, String name, Object ... args) {
        try {
            Method method = type.getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return (T)method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T get(Object target, String name) {
        try {
            Field f;
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                if ((target = ReflectionUtils.drillField(target, name.substring(0, idx))) == null) {
                    throw new IllegalStateException("Could not find field '" + name + "'");
                }
                name = name.substring(idx + 1);
            }
            if ((f = ReflectionUtils.findField(target.getClass(), name)) == null) {
                throw new IllegalStateException("Could not find '" + name + "'");
            }
            return (T)f.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

