/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.gradle;

import com.amadornes.artifactural.api.artifact.Artifact;
import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.artifact.MissingArtifactException;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.artifact.SimpleArtifactIdentifier;
import com.amadornes.artifactural.base.cache.LocatedArtifactCache;
import com.amadornes.artifactural.gradle.Gradle410RepositoryAdapter;
import com.amadornes.artifactural.gradle.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.AbstractArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenLocalArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocalFileStandInExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.DefaultCacheAwareExternalResourceAccessor;
import org.gradle.util.GradleVersion;

public class GradleRepositoryAdapter
extends AbstractArtifactRepository
implements ResolutionAwareRepository {
    private static final Pattern URL_PATTERN = Pattern.compile("^(?<group>\\S+(?:/\\S+)*)/(?<name>\\S+)/(?<version>\\S+)/\\2-\\3(?:-(?<classifier>[^.\\s]+))?\\.(?<extension>\\S+)$");
    private final Repository repository;
    private final DefaultMavenLocalArtifactRepository local;
    private final String root;
    private final LocatedArtifactCache cache;

    public static GradleRepositoryAdapter add(RepositoryHandler handler, String name, File local, Repository repository) {
        BaseRepositoryFactory factory = (BaseRepositoryFactory)ReflectionUtils.get(handler, "repositoryFactory");
        DefaultMavenLocalArtifactRepository maven = (DefaultMavenLocalArtifactRepository)factory.createMavenLocalRepository();
        maven.setUrl((Object)local);
        maven.setName(name);
        GradleRepositoryAdapter repo = GradleVersion.current().compareTo(GradleVersion.version((String)"4.10")) >= 0 ? new Gradle410RepositoryAdapter(null, repository, maven) : new GradleRepositoryAdapter(repository, maven);
        repo.setName(name);
        handler.add((ArtifactRepository)repo);
        return repo;
    }

    private GradleRepositoryAdapter(Repository repository, DefaultMavenLocalArtifactRepository local) {
        this.repository = repository;
        this.local = local;
        this.root = GradleRepositoryAdapter.cleanRoot(local.getUrl());
        this.cache = new LocatedArtifactCache(new File(this.root));
    }

    GradleRepositoryAdapter(ObjectFactory objectFactory, Repository repository, DefaultMavenLocalArtifactRepository local) {
        super(objectFactory);
        this.repository = repository;
        this.local = local;
        this.root = GradleRepositoryAdapter.cleanRoot(local.getUrl());
        this.cache = new LocatedArtifactCache(new File(this.root));
    }

    public String getDisplayName() {
        return this.local.getDisplayName();
    }

    public ConfiguredModuleComponentRepository createResolver() {
        final MavenResolver resolver = (MavenResolver)this.local.createResolver();
        GeneratingFileResourceRepository repo = new GeneratingFileResourceRepository();
        ReflectionUtils.alter(resolver, "repository", prev -> repo);
        DefaultCacheAwareExternalResourceAccessor accessor = (DefaultCacheAwareExternalResourceAccessor)ReflectionUtils.get(resolver, "mavenMetaDataLoader.cacheAwareExternalResourceAccessor.delegate");
        ReflectionUtils.alter(accessor, "delegate", prev -> repo);
        ReflectionUtils.alter(accessor, "fileResourceRepository", prev -> repo);
        ExternalResourceArtifactResolver extResolver = (ExternalResourceArtifactResolver)ReflectionUtils.invoke(resolver, ExternalResourceResolver.class, "createArtifactResolver", new Object[0]);
        ReflectionUtils.alter(extResolver, "repository", prev -> repo);
        ReflectionUtils.alter(resolver, "cachingResourceAccessor.this$0.repository", prev -> repo);
        ReflectionUtils.alter(resolver, "cachingResourceAccessor.delegate.delegate", prev -> repo);
        return new ConfiguredModuleComponentRepository(){
            private final ModuleComponentRepositoryAccess local;
            private final ModuleComponentRepositoryAccess remote;
            {
                this.local = this.wrap(resolver.getLocalAccess());
                this.remote = this.wrap(resolver.getRemoteAccess());
            }

            public String getId() {
                return resolver.getId();
            }

            public String getName() {
                return resolver.getName();
            }

            public ModuleComponentRepositoryAccess getLocalAccess() {
                return this.local;
            }

            public ModuleComponentRepositoryAccess getRemoteAccess() {
                return this.remote;
            }

            public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
                return resolver.getArtifactCache();
            }

            public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
                return resolver.getComponentMetadataSupplier();
            }

            public boolean isDynamicResolveMode() {
                return resolver.isDynamicResolveMode();
            }

            public boolean isLocal() {
                return resolver.isLocal();
            }

            private ModuleComponentRepositoryAccess wrap(final ModuleComponentRepositoryAccess delegate) {
                return new ModuleComponentRepositoryAccess(){

                    public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
                        ModuleComponentResolveMetadata meta;
                        delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
                        if (result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved && (meta = result.getMetaData()).isMissing()) {
                            MutableModuleComponentResolveMetadata mutable = meta.asMutable();
                            mutable.setChanging(true);
                            mutable.setMissing(false);
                            result.resolved(mutable.asImmutable());
                        }
                    }

                    public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
                        delegate.listModuleVersions(dependency, result);
                    }

                    public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
                        delegate.resolveArtifacts(component, result);
                    }

                    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
                        delegate.resolveArtifactsWithType(component, artifactType, result);
                    }

                    public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
                        delegate.resolveArtifact(artifact, moduleSource, result);
                    }

                    public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
                        return delegate.estimateMetadataFetchingCost(moduleComponentIdentifier);
                    }
                };
            }
        };
    }

    private static String cleanRoot(URI uri) {
        String ret = uri.normalize().getPath().replace('\\', '/');
        if (!ret.endsWith("/")) {
            ret = ret + '/';
        }
        return ret;
    }

    public File getArtifact(ArtifactIdentifier identifier) {
        Artifact art = this.repository.getArtifact(identifier);
        if (!art.isPresent()) {
            return null;
        }
        Artifact.Cached cached = art.optionallyCache(this.cache);
        try {
            return cached.asFile();
        }
        catch (MissingArtifactException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class GeneratingFileResourceRepository
    implements FileResourceRepository {
        private final FileSystem fileSystem = FileSystems.getDefault();

        private GeneratingFileResourceRepository() {
        }

        private void debug(String message) {
        }

        private void log(String message) {
            System.out.println(message);
        }

        public ExternalResourceRepository withProgressLogging() {
            return this;
        }

        public LocalBinaryResource localResource(File file) {
            this.debug("localResource: " + file);
            return null;
        }

        public LocallyAvailableExternalResource resource(File file) {
            this.debug("resource(File): " + file);
            return this.findArtifact(file.getAbsolutePath().replace('\\', '/'));
        }

        public LocallyAvailableExternalResource resource(ExternalResourceName location) {
            return this.resource(location, false);
        }

        public LocallyAvailableExternalResource resource(ExternalResourceName location, boolean revalidate) {
            this.debug("resource(ExternalResourceName,boolean): " + location + ", " + revalidate);
            return this.findArtifact(location.getUri().getPath().replace('\\', '/'));
        }

        public LocallyAvailableExternalResource resource(File file, URI originUri, ExternalResourceMetaData originMetadata) {
            this.debug("resource(File,URI,ExternalResourceMetaData): " + file + ", " + originUri + ", " + originMetadata);
            return this.findArtifact(file.getAbsolutePath().replace('\\', '/'));
        }

        private LocallyAvailableExternalResource findArtifact(String path) {
            if (path.startsWith(GradleRepositoryAdapter.this.root)) {
                String relative = path.substring(GradleRepositoryAdapter.this.root.length());
                this.debug("  Relative: " + relative);
                Matcher matcher = URL_PATTERN.matcher(relative);
                if (matcher.matches()) {
                    SimpleArtifactIdentifier identifier = new SimpleArtifactIdentifier(matcher.group("group").replace('/', '.'), matcher.group("name"), matcher.group("version"), matcher.group("classifier"), matcher.group("extension"));
                    Artifact artifact = GradleRepositoryAdapter.this.repository.getArtifact(identifier);
                    return this.wrap(artifact, identifier);
                }
                if (relative.endsWith("maven-metadata.xml")) {
                    File ret;
                    String tmp = relative.substring(0, relative.length() - "maven-metadata.xml".length() - 1);
                    int idx = tmp.lastIndexOf(47);
                    if (idx != -1 && (ret = GradleRepositoryAdapter.this.repository.getMavenMetadata(tmp.substring(0, idx - 1), tmp.substring(idx))) != null) {
                        return new LocalFileStandInExternalResource(ret, this.fileSystem);
                    }
                } else if (relative.endsWith("/")) {
                    this.debug("    Directory listing not supported");
                } else {
                    this.log("  Matcher Failed: " + relative);
                }
            } else {
                this.log("Unknown root: " + path);
            }
            return new LocalFileStandInExternalResource(new File(path), this.fileSystem);
        }

        private LocallyAvailableExternalResource wrap(Artifact artifact, ArtifactIdentifier id) {
            if (!artifact.isPresent()) {
                return new LocalFileStandInExternalResource(GradleRepositoryAdapter.this.cache.getPath(artifact), this.fileSystem);
            }
            Artifact.Cached cached = artifact.optionallyCache(GradleRepositoryAdapter.this.cache);
            try {
                return new LocalFileStandInExternalResource(cached.asFile(), this.fileSystem);
            }
            catch (MissingArtifactException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

