/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.gradle;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;

public class DependencyResolver {
    private final Project project;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Cache<String, CompletableFuture<Set<File>>> resolved = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();

    public DependencyResolver(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> resolveDependency(Dependency dependency) {
        CompletableFuture<Set> future;
        Set artifacts;
        if (dependency instanceof FileCollectionDependency) {
            return ((FileCollectionDependency)dependency).getFiles().getFiles();
        }
        String name = dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion();
        if (dependency instanceof ModuleDependency && !(artifacts = ((ModuleDependency)dependency).getArtifacts()).isEmpty()) {
            DependencyArtifact artifact = (DependencyArtifact)artifacts.iterator().next();
            name = name + ":" + artifact.getClassifier() + "@" + artifact.getExtension();
        }
        boolean found = true;
        Cache<String, CompletableFuture<Set<File>>> cache = this.resolved;
        synchronized (cache) {
            future = (CompletableFuture<Set>)this.resolved.getIfPresent((Object)name);
            if (future == null) {
                future = new CompletableFuture<Set>();
                this.resolved.put((Object)name, future);
                found = false;
            }
        }
        if (found) {
            try {
                return (Set)future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        int currentID = this.counter.getAndIncrement();
        Configuration cfg = (Configuration)this.project.getConfigurations().maybeCreate("resolve_dep_" + currentID);
        cfg.getDependencies().add((Object)dependency);
        Set files = cfg.resolve();
        this.project.getConfigurations().remove((Object)cfg);
        future.complete(files);
        return files;
    }

    public Set<File> resolveDependency(Object dependency) {
        Dependency dep = this.project.getDependencies().create(dependency);
        return this.resolveDependency(dep);
    }

    public Set<File> resolveDependency(Object dependency, boolean transitive) {
        Dependency dep = this.project.getDependencies().create(dependency);
        if (dep instanceof ClientModule) {
            dep = ((ClientModule)dep).copy().setTransitive(transitive);
        }
        return this.resolveDependency(dep);
    }

    public File resolveSingleDependency(Object dependency) {
        return this.resolveDependency(dependency, false).iterator().next();
    }
}

