/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.base.util;

import java.util.Map;

public class PatternReplace {
    public static String replace(String pattern, Map<String, String> values) {
        if (pattern == null) {
            return null;
        }
        if (pattern.isEmpty()) {
            return "";
        }
        Optional optional = null;
        StringBuffer name = null;
        StringBuffer ret = new StringBuffer();
        char[] chars = pattern.toCharArray();
        block6: for (int x = 0; x < chars.length; ++x) {
            char c = chars[x];
            if (c == '\\') {
                if (x == chars.length - 1) {
                    throw new IllegalArgumentException("Escape character can not be end of pattern: " + pattern);
                }
                ret.append(chars[++x]);
                continue;
            }
            switch (c) {
                case '[': {
                    if (name != null) {
                        throw new IllegalArgumentException("Nested names are not supported @ " + x + " : " + pattern);
                    }
                    name = new StringBuffer();
                    continue block6;
                }
                case ']': {
                    if (name == null) {
                        throw new IllegalArgumentException("Name closing found without opening @ " + x + " : " + pattern);
                    }
                    String key = name.toString();
                    if (key.isEmpty()) {
                        throw new IllegalArgumentException("Name can not be empty @ " + x + ": " + pattern);
                    }
                    if (optional != null) {
                        optional.setKey(key, values);
                    } else {
                        ret.append(values.get(key));
                    }
                    name = null;
                    continue block6;
                }
                case '(': {
                    optional = new Optional(optional);
                    continue block6;
                }
                case ')': {
                    if (optional == null) {
                        throw new IllegalArgumentException("Optional closing found without opening @ " + x + ": " + pattern);
                    }
                    optional = optional.finish(x, pattern, ret);
                    continue block6;
                }
                default: {
                    if (name != null) {
                        name.append(c);
                        continue block6;
                    }
                    if (optional != null) {
                        optional.append(c);
                        continue block6;
                    }
                    ret.append(c);
                }
            }
        }
        if (optional != null) {
            throw new IllegalArgumentException("Missing closing of optional value: " + pattern);
        }
        if (name != null) {
            throw new IllegalArgumentException("Missing closing of name entry: " + pattern);
        }
        return ret.toString();
    }

    public static String quote(String value) {
        return value.replaceAll("\\", "\\\\").replaceAll("(", "\\(").replaceAll(")", "\\)").replaceAll("[", "\\[").replaceAll("]", "\\]");
    }

    private static class Optional {
        private final Optional parent;
        private final StringBuffer buf = new StringBuffer();
        private boolean hadAll = true;
        private boolean hadValue = false;

        private Optional(Optional parent) {
            this.parent = parent;
        }

        public void append(char c) {
            this.buf.append(c);
        }

        private void setKey(String key, Map<String, String> values) {
            this.hadValue = true;
            String value = values.get(key);
            if (value != null && !value.isEmpty()) {
                this.hadAll &= true;
                this.buf.append(value);
            } else {
                this.hadAll = false;
            }
        }

        public Optional finish(int position, String pattern, StringBuffer ret) {
            if (!this.hadValue) {
                throw new IllegalArgumentException("Invalid optional, missing inner name @ " + position + ": " + pattern);
            }
            if (this.hadAll) {
                (this.parent == null ? ret : this.parent.buf).append(this.buf);
            }
            return this.parent;
        }
    }
}

