/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.base.cache;

import com.amadornes.artifactural.api.artifact.Artifact;
import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.base.cache.ArtifactCacheBase;
import com.amadornes.artifactural.base.util.PatternReplace;
import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LocatedArtifactCache
extends ArtifactCacheBase {
    private static final String PATTERN = "[group]/[name](/[meta_hash])/[version]/[name]-[version](-[classifier])(-[specifier]).[extension]";
    private final File path;

    public LocatedArtifactCache(File path) {
        this.path = path;
    }

    @Override
    public Artifact.Cached store(Artifact artifact) {
        return this.doStore(this.getPath(artifact), artifact);
    }

    public File getPath(Artifact artifact) {
        ArtifactIdentifier identifier = artifact.getIdentifier();
        Map<String, String> names = Stream.of(LocatedArtifactCache.entry("group", identifier.getGroup()), LocatedArtifactCache.entry("name", identifier.getName()), LocatedArtifactCache.entry("version", identifier.getVersion()), LocatedArtifactCache.entry("classifier", identifier.getClassifier()), LocatedArtifactCache.entry("extension", identifier.getExtension()), LocatedArtifactCache.entry("meta_hash", artifact.getMetadata().getHash())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new File(this.path, PatternReplace.replace(PATTERN, names));
    }

    private static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public String toString() {
        return "LocatedArtifactCache(" + this.path + ")";
    }
}

