/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.api.artifact;

import com.amadornes.artifactural.api.artifact.Internal;
import java.util.function.Predicate;

public interface ArtifactIdentifier {
    public static ArtifactIdentifier none() {
        return Internal.NO_IDENTIFIER;
    }

    public String getGroup();

    public String getName();

    public String getVersion();

    public String getClassifier();

    public String getExtension();

    public static Predicate<ArtifactIdentifier> groupMatches(String group) {
        return identifier -> identifier.getGroup().matches(group);
    }

    public static Predicate<ArtifactIdentifier> nameMatches(String name) {
        return identifier -> identifier.getName().matches(name);
    }

    public static Predicate<ArtifactIdentifier> versionMatches(String version) {
        return identifier -> identifier.getVersion().matches(version);
    }

    public static Predicate<ArtifactIdentifier> classifierMatches(String classifier) {
        return identifier -> identifier.getClassifier().matches(classifier);
    }

    public static Predicate<ArtifactIdentifier> extensionMatches(String extension) {
        return identifier -> identifier.getExtension().matches(extension);
    }

    public static Predicate<ArtifactIdentifier> groupEquals(String group) {
        return identifier -> identifier.getGroup().equals(group);
    }

    public static Predicate<ArtifactIdentifier> nameEquals(String name) {
        return identifier -> identifier.getName().equals(name);
    }

    public static Predicate<ArtifactIdentifier> versionEquals(String version) {
        return identifier -> identifier.getVersion().equals(version);
    }

    public static Predicate<ArtifactIdentifier> classifierEquals(String classifier) {
        return identifier -> identifier.getClassifier().equals(classifier);
    }

    public static Predicate<ArtifactIdentifier> extensionEquals(String extension) {
        return identifier -> identifier.getExtension().equals(extension);
    }
}

