/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.artifactural.api.artifact;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.artifact.ArtifactMetadata;
import com.amadornes.artifactural.api.artifact.ArtifactType;
import com.amadornes.artifactural.api.artifact.Internal;
import com.amadornes.artifactural.api.artifact.MissingArtifactException;
import com.amadornes.artifactural.api.cache.ArtifactCache;
import com.amadornes.artifactural.api.transform.ArtifactTransformer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public interface Artifact {
    public static Artifact none() {
        return Internal.NO_ARTIFACT;
    }

    public ArtifactIdentifier getIdentifier();

    public ArtifactMetadata getMetadata();

    public ArtifactType getType();

    public Artifact withMetadata(ArtifactMetadata var1);

    public Artifact apply(ArtifactTransformer var1);

    public Cached cache(ArtifactCache var1);

    default public Cached optionallyCache(ArtifactCache cache) {
        return this instanceof Cached ? (Cached)this : this.cache(cache);
    }

    public boolean isPresent();

    public InputStream openStream() throws IOException, MissingArtifactException;

    public static interface Cached
    extends Artifact {
        public File asFile() throws IOException, MissingArtifactException;

        public File getFileLocation() throws IOException, MissingArtifactException;
    }
}

