/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer.service;

import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.accesstransformer.AccessTransformerEngine;
import net.minecraftforge.accesstransformer.service.ServiceNameHandler;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class AccessTransformerService
implements ILaunchPluginService {
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.BEFORE);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);

    @Override
    public String name() {
        return "accesstransformer";
    }

    @Override
    public void offerResource(Path path, String resourceName) {
        AccessTransformerEngine.INSTANCE.addResource(path, resourceName);
    }

    @Override
    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        return AccessTransformerEngine.INSTANCE.transform(classNode, classType) ? 256 : 0;
    }

    @Override
    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return !isEmpty && AccessTransformerEngine.INSTANCE.handlesClass(classType) ? YAY : NAY;
    }

    public Consumer<Map.Entry<String, String>> getExtension() {
        return this::setNameHandler;
    }

    private void setNameHandler(Map.Entry<String, String> naming) {
        AccessTransformerEngine.INSTANCE.acceptNaming(new ServiceNameHandler(naming.getKey(), naming.getValue()));
    }
}

